<?php

namespace AlibabaCloud\Ens\V20171110;

use AlibabaCloud\Client\Resolver\ApiResolver;

/**
 * @method AccosicateNetworkAcl accosicateNetworkAcl(array $options = [])
 * @method AddBackendServers addBackendServers(array $options = [])
 * @method AddDeviceInternetPort addDeviceInternetPort(array $options = [])
 * @method AddNetworkInterfaceToInstance addNetworkInterfaceToInstance(array $options = [])
 * @method AddSnatIpForSnatEntry addSnatIpForSnatEntry(array $options = [])
 * @method AssignPrivateIpAddresses assignPrivateIpAddresses(array $options = [])
 * @method AssociateEnsEipAddress associateEnsEipAddress(array $options = [])
 * @method AssociateHaVip associateHaVip(array $options = [])
 * @method AttachDisk attachDisk(array $options = [])
 * @method AttachEnsInstances attachEnsInstances(array $options = [])
 * @method AttachNetworkInterface attachNetworkInterface(array $options = [])
 * @method AuthorizeSecurityGroup authorizeSecurityGroup(array $options = [])
 * @method AuthorizeSecurityGroupEgress authorizeSecurityGroupEgress(array $options = [])
 * @method CleanDistData cleanDistData(array $options = [])
 * @method CopySDG copySDG(array $options = [])
 * @method CopySnapshot copySnapshot(array $options = [])
 * @method CreateApplication createApplication(array $options = [])
 * @method CreateARMServerInstances createARMServerInstances(array $options = [])
 * @method CreateClassicNetwork createClassicNetwork(array $options = [])
 * @method CreateCluster createCluster(array $options = [])
 * @method CreateDisk createDisk(array $options = [])
 * @method CreateEipInstance createEipInstance(array $options = [])
 * @method CreateEnsRouteEntry createEnsRouteEntry(array $options = [])
 * @method CreateEnsSaleControl createEnsSaleControl(array $options = [])
 * @method CreateEnsService createEnsService(array $options = [])
 * @method CreateEpnInstance createEpnInstance(array $options = [])
 * @method CreateFileSystem createFileSystem(array $options = [])
 * @method CreateForwardEntry createForwardEntry(array $options = [])
 * @method CreateImage createImage(array $options = [])
 * @method CreateInstance createInstance(array $options = [])
 * @method CreateInstanceActiveOpsTask createInstanceActiveOpsTask(array $options = [])
 * @method CreateKeyPair createKeyPair(array $options = [])
 * @method CreateLoadBalancer createLoadBalancer(array $options = [])
 * @method CreateLoadBalancerHTTPListener createLoadBalancerHTTPListener(array $options = [])
 * @method CreateLoadBalancerHTTPSListener createLoadBalancerHTTPSListener(array $options = [])
 * @method CreateLoadBalancerTCPListener createLoadBalancerTCPListener(array $options = [])
 * @method CreateLoadBalancerUDPListener createLoadBalancerUDPListener(array $options = [])
 * @method CreateMountTarget createMountTarget(array $options = [])
 * @method CreateNatGateway createNatGateway(array $options = [])
 * @method CreateNetwork createNetwork(array $options = [])
 * @method CreateNetworkAcl createNetworkAcl(array $options = [])
 * @method CreateNetworkAclEntry createNetworkAclEntry(array $options = [])
 * @method CreateSDG createSDG(array $options = [])
 * @method CreateSecurityGroup createSecurityGroup(array $options = [])
 * @method CreateSnapshot createSnapshot(array $options = [])
 * @method CreateSnatEntry createSnatEntry(array $options = [])
 * @method CreateStorageGateway createStorageGateway(array $options = [])
 * @method CreateStorageVolume createStorageVolume(array $options = [])
 * @method CreateVSwitch createVSwitch(array $options = [])
 * @method DeleteApplication deleteApplication(array $options = [])
 * @method DeleteBucket deleteBucket(array $options = [])
 * @method DeleteBucketLifecycle deleteBucketLifecycle(array $options = [])
 * @method DeleteDeviceInternetPort deleteDeviceInternetPort(array $options = [])
 * @method DeleteDisk deleteDisk(array $options = [])
 * @method DeleteEnsRouteEntry deleteEnsRouteEntry(array $options = [])
 * @method DeleteEnsSaleConditionControl deleteEnsSaleConditionControl(array $options = [])
 * @method DeleteEnsSaleControl deleteEnsSaleControl(array $options = [])
 * @method DeleteEpnInstance deleteEpnInstance(array $options = [])
 * @method DeleteFileSystem deleteFileSystem(array $options = [])
 * @method DeleteForwardEntry deleteForwardEntry(array $options = [])
 * @method DeleteImage deleteImage(array $options = [])
 * @method DeleteKeyPairs deleteKeyPairs(array $options = [])
 * @method DeleteLoadBalancerListener deleteLoadBalancerListener(array $options = [])
 * @method DeleteMountTarget deleteMountTarget(array $options = [])
 * @method DeleteNatGateway deleteNatGateway(array $options = [])
 * @method DeleteNetwork deleteNetwork(array $options = [])
 * @method DeleteNetworkAcl deleteNetworkAcl(array $options = [])
 * @method DeleteNetworkAclEntry deleteNetworkAclEntry(array $options = [])
 * @method DeleteObject deleteObject(array $options = [])
 * @method DeleteSDG deleteSDG(array $options = [])
 * @method DeleteSecurityGroup deleteSecurityGroup(array $options = [])
 * @method DeleteSnapshot deleteSnapshot(array $options = [])
 * @method DeleteSnatEntry deleteSnatEntry(array $options = [])
 * @method DeleteSnatIpForSnatEntry deleteSnatIpForSnatEntry(array $options = [])
 * @method DeleteStorageGateway deleteStorageGateway(array $options = [])
 * @method DeleteStorageVolume deleteStorageVolume(array $options = [])
 * @method DeleteVSwitch deleteVSwitch(array $options = [])
 * @method DeployInstanceSDG deployInstanceSDG(array $options = [])
 * @method DeploySDG deploySDG(array $options = [])
 * @method DescribeAICImages describeAICImages(array $options = [])
 * @method DescribeApplication describeApplication(array $options = [])
 * @method DescribeARMServerInstances describeARMServerInstances(array $options = [])
 * @method DescribeAvailableResource describeAvailableResource(array $options = [])
 * @method DescribeAvailableResourceInfo describeAvailableResourceInfo(array $options = [])
 * @method DescribeBandwitdhByInternetChargeType describeBandwitdhByInternetChargeType(array $options = [])
 * @method DescribeBandWithdChargeType describeBandWithdChargeType(array $options = [])
 * @method DescribeCloudDiskAvailableResourceInfo describeCloudDiskAvailableResourceInfo(array $options = [])
 * @method DescribeCloudDiskTypes describeCloudDiskTypes(array $options = [])
 * @method DescribeCluster describeCluster(array $options = [])
 * @method DescribeClusterKubeConfig describeClusterKubeConfig(array $options = [])
 * @method DescribeCreatePrePaidInstanceResult describeCreatePrePaidInstanceResult(array $options = [])
 * @method DescribeDataDistResult describeDataDistResult(array $options = [])
 * @method DescribeDataDownloadURL describeDataDownloadURL(array $options = [])
 * @method DescribeDataPushResult describeDataPushResult(array $options = [])
 * @method DescribeDeviceService describeDeviceService(array $options = [])
 * @method DescribeDiskIopsList describeDiskIopsList(array $options = [])
 * @method DescribeDisks describeDisks(array $options = [])
 * @method DescribeElbAvailableResourceInfo describeElbAvailableResourceInfo(array $options = [])
 * @method DescribeEnsCommodityCode describeEnsCommodityCode(array $options = [])
 * @method DescribeEnsCommodityModuleCode describeEnsCommodityModuleCode(array $options = [])
 * @method DescribeEnsEipAddresses describeEnsEipAddresses(array $options = [])
 * @method DescribeEnsNetDistrict describeEnsNetDistrict(array $options = [])
 * @method DescribeEnsNetLevel describeEnsNetLevel(array $options = [])
 * @method DescribeEnsNetSaleDistrict describeEnsNetSaleDistrict(array $options = [])
 * @method DescribeEnsRegionIdIpv6Info describeEnsRegionIdIpv6Info(array $options = [])
 * @method DescribeEnsRegionIdResource describeEnsRegionIdResource(array $options = [])
 * @method DescribeEnsRegions describeEnsRegions(array $options = [])
 * @method DescribeEnsResourceUsage describeEnsResourceUsage(array $options = [])
 * @method DescribeEnsRouteEntryList describeEnsRouteEntryList(array $options = [])
 * @method DescribeEnsSaleControl describeEnsSaleControl(array $options = [])
 * @method DescribeEnsSaleControlAvailableResource describeEnsSaleControlAvailableResource(array $options = [])
 * @method DescribeEnsSaleControlStock describeEnsSaleControlStock(array $options = [])
 * @method DescribeEpnBandWidthData describeEpnBandWidthData(array $options = [])
 * @method DescribeEpnBandwitdhByInternetChargeType describeEpnBandwitdhByInternetChargeType(array $options = [])
 * @method DescribeEpnInstanceAttribute describeEpnInstanceAttribute(array $options = [])
 * @method DescribeEpnInstances describeEpnInstances(array $options = [])
 * @method DescribeEpnMeasurementData describeEpnMeasurementData(array $options = [])
 * @method DescribeExportImageInfo describeExportImageInfo(array $options = [])
 * @method DescribeExportImageStatus describeExportImageStatus(array $options = [])
 * @method DescribeFileSystems describeFileSystems(array $options = [])
 * @method DescribeForwardTableEntries describeForwardTableEntries(array $options = [])
 * @method DescribeHaVips describeHaVips(array $options = [])
 * @method DescribeImageInfos describeImageInfos(array $options = [])
 * @method DescribeImages describeImages(array $options = [])
 * @method DescribeImageSharePermission describeImageSharePermission(array $options = [])
 * @method DescribeInstanceAutoRenewAttribute describeInstanceAutoRenewAttribute(array $options = [])
 * @method DescribeInstanceBandwidthDetail describeInstanceBandwidthDetail(array $options = [])
 * @method DescribeInstanceMonitorData describeInstanceMonitorData(array $options = [])
 * @method DescribeInstances describeInstances(array $options = [])
 * @method DescribeInstanceSpec describeInstanceSpec(array $options = [])
 * @method DescribeInstanceTypes describeInstanceTypes(array $options = [])
 * @method DescribeInstanceVncUrl describeInstanceVncUrl(array $options = [])
 * @method DescribeKeyPairs describeKeyPairs(array $options = [])
 * @method DescribeLoadBalancerAttribute describeLoadBalancerAttribute(array $options = [])
 * @method DescribeLoadBalancerHTTPListenerAttribute describeLoadBalancerHTTPListenerAttribute(array $options = [])
 * @method DescribeLoadBalancerHTTPSListenerAttribute describeLoadBalancerHTTPSListenerAttribute(array $options = [])
 * @method DescribeLoadBalancerListeners describeLoadBalancerListeners(array $options = [])
 * @method DescribeLoadBalancerListenMonitor describeLoadBalancerListenMonitor(array $options = [])
 * @method DescribeLoadBalancers describeLoadBalancers(array $options = [])
 * @method DescribeLoadBalancerSpec describeLoadBalancerSpec(array $options = [])
 * @method DescribeLoadBalancerTCPListenerAttribute describeLoadBalancerTCPListenerAttribute(array $options = [])
 * @method DescribeLoadBalancerUDPListenerAttribute describeLoadBalancerUDPListenerAttribute(array $options = [])
 * @method DescribeMeasurementData describeMeasurementData(array $options = [])
 * @method DescribeMountTargets describeMountTargets(array $options = [])
 * @method DescribeNatGateways describeNatGateways(array $options = [])
 * @method DescribeNCInformation describeNCInformation(array $options = [])
 * @method DescribeNetworkAcls describeNetworkAcls(array $options = [])
 * @method DescribeNetworkAttribute describeNetworkAttribute(array $options = [])
 * @method DescribeNetworkInterfaces describeNetworkInterfaces(array $options = [])
 * @method DescribeNetworks describeNetworks(array $options = [])
 * @method DescribePrePaidInstanceStock describePrePaidInstanceStock(array $options = [])
 * @method DescribePrice describePrice(array $options = [])
 * @method DescribeRegionIsps describeRegionIsps(array $options = [])
 * @method DescribeRegionResource describeRegionResource(array $options = [])
 * @method DescribeReservedResource describeReservedResource(array $options = [])
 * @method DescribeResourceTimeline describeResourceTimeline(array $options = [])
 * @method DescribeSDG describeSDG(array $options = [])
 * @method DescribeSDGDeploymentStatus describeSDGDeploymentStatus(array $options = [])
 * @method DescribeSDGs describeSDGs(array $options = [])
 * @method DescribeSecondaryPublicIpAddresses describeSecondaryPublicIpAddresses(array $options = [])
 * @method DescribeSecurityGroupAttribute describeSecurityGroupAttribute(array $options = [])
 * @method DescribeSecurityGroups describeSecurityGroups(array $options = [])
 * @method DescribeSelfImages describeSelfImages(array $options = [])
 * @method DescribeServcieSchedule describeServcieSchedule(array $options = [])
 * @method DescribeServerLoadBalancerListenMonitor describeServerLoadBalancerListenMonitor(array $options = [])
 * @method DescribeServerLoadBalancerMonitor describeServerLoadBalancerMonitor(array $options = [])
 * @method DescribeSnapshots describeSnapshots(array $options = [])
 * @method DescribeSnatAttribute describeSnatAttribute(array $options = [])
 * @method DescribeSnatTableEntries describeSnatTableEntries(array $options = [])
 * @method DescribeStorageGateway describeStorageGateway(array $options = [])
 * @method DescribeStorageVolume describeStorageVolume(array $options = [])
 * @method DescribeUserBandWidthData describeUserBandWidthData(array $options = [])
 * @method DescribeVSwitches describeVSwitches(array $options = [])
 * @method DetachDisk detachDisk(array $options = [])
 * @method DetachNetworkInterface detachNetworkInterface(array $options = [])
 * @method DistApplicationData distApplicationData(array $options = [])
 * @method ExportBillDetailData exportBillDetailData(array $options = [])
 * @method ExportImage exportImage(array $options = [])
 * @method ExportMeasurementData exportMeasurementData(array $options = [])
 * @method GetBucketAcl getBucketAcl(array $options = [])
 * @method GetBucketInfo getBucketInfo(array $options = [])
 * @method GetBucketLifecycle getBucketLifecycle(array $options = [])
 * @method GetDeviceInternetPort getDeviceInternetPort(array $options = [])
 * @method GetOssStorageAndAccByBuckets getOssStorageAndAccByBuckets(array $options = [])
 * @method GetOssUsageData getOssUsageData(array $options = [])
 * @method ImportKeyPair importKeyPair(array $options = [])
 * @method JoinPublicIpsToEpnInstance joinPublicIpsToEpnInstance(array $options = [])
 * @method JoinSecurityGroup joinSecurityGroup(array $options = [])
 * @method JoinVSwitchesToEpnInstance joinVSwitchesToEpnInstance(array $options = [])
 * @method LeaveSecurityGroup leaveSecurityGroup(array $options = [])
 * @method ListApplications listApplications(array $options = [])
 * @method ListBuckets listBuckets(array $options = [])
 * @method ListObjects listObjects(array $options = [])
 * @method ListTagResources listTagResources(array $options = [])
 * @method ModifyEnsEipAddressAttribute modifyEnsEipAddressAttribute(array $options = [])
 * @method ModifyEpnInstance modifyEpnInstance(array $options = [])
 * @method ModifyFileSystem modifyFileSystem(array $options = [])
 * @method ModifyForwardEntry modifyForwardEntry(array $options = [])
 * @method ModifyHaVipAttribute modifyHaVipAttribute(array $options = [])
 * @method ModifyImageAttribute modifyImageAttribute(array $options = [])
 * @method ModifyImageSharePermission modifyImageSharePermission(array $options = [])
 * @method ModifyInstanceAttribute modifyInstanceAttribute(array $options = [])
 * @method ModifyInstanceAutoRenewAttribute modifyInstanceAutoRenewAttribute(array $options = [])
 * @method ModifyInstanceBootConfiguration modifyInstanceBootConfiguration(array $options = [])
 * @method ModifyInstanceChargeType modifyInstanceChargeType(array $options = [])
 * @method ModifyLoadBalancerAttribute modifyLoadBalancerAttribute(array $options = [])
 * @method ModifyNetworkAttribute modifyNetworkAttribute(array $options = [])
 * @method ModifyNetworkInterfaceAttribute modifyNetworkInterfaceAttribute(array $options = [])
 * @method ModifyPrepayInstanceSpec modifyPrepayInstanceSpec(array $options = [])
 * @method ModifySecurityGroupAttribute modifySecurityGroupAttribute(array $options = [])
 * @method ModifySnapshotAttribute modifySnapshotAttribute(array $options = [])
 * @method ModifyVSwitchAttribute modifyVSwitchAttribute(array $options = [])
 * @method PreloadRegionSDG preloadRegionSDG(array $options = [])
 * @method PrepareUpload prepareUpload(array $options = [])
 * @method PushApplicationData pushApplicationData(array $options = [])
 * @method PutBucket putBucket(array $options = [])
 * @method PutBucketAcl putBucketAcl(array $options = [])
 * @method PutBucketLifecycle putBucketLifecycle(array $options = [])
 * @method RebootAICInstance rebootAICInstance(array $options = [])
 * @method RebootARMServerInstance rebootARMServerInstance(array $options = [])
 * @method RebootInstance rebootInstance(array $options = [])
 * @method RebootInstances rebootInstances(array $options = [])
 * @method RecoverAICInstance recoverAICInstance(array $options = [])
 * @method ReInitDisk reInitDisk(array $options = [])
 * @method ReinitInstance reinitInstance(array $options = [])
 * @method ReinitInstances reinitInstances(array $options = [])
 * @method ReleaseAICInstance releaseAICInstance(array $options = [])
 * @method ReleaseARMServerInstance releaseARMServerInstance(array $options = [])
 * @method ReleaseInstance releaseInstance(array $options = [])
 * @method ReleasePostPaidInstance releasePostPaidInstance(array $options = [])
 * @method ReleasePrePaidInstance releasePrePaidInstance(array $options = [])
 * @method RemoveBackendServers removeBackendServers(array $options = [])
 * @method RemoveInstanceSDG removeInstanceSDG(array $options = [])
 * @method RemovePublicIpsFromEpnInstance removePublicIpsFromEpnInstance(array $options = [])
 * @method RemoveSDG removeSDG(array $options = [])
 * @method RemoveVSwitchesFromEpnInstance removeVSwitchesFromEpnInstance(array $options = [])
 * @method RenewARMServerInstance renewARMServerInstance(array $options = [])
 * @method RenewInstance renewInstance(array $options = [])
 * @method RescaleApplication rescaleApplication(array $options = [])
 * @method RescaleDeviceService rescaleDeviceService(array $options = [])
 * @method ResetAICInstance resetAICInstance(array $options = [])
 * @method ResetDeviceInstance resetDeviceInstance(array $options = [])
 * @method ResetDisk resetDisk(array $options = [])
 * @method ResizeDisk resizeDisk(array $options = [])
 * @method RestartDeviceInstance restartDeviceInstance(array $options = [])
 * @method RevokeSecurityGroup revokeSecurityGroup(array $options = [])
 * @method RevokeSecurityGroupEgress revokeSecurityGroupEgress(array $options = [])
 * @method RollbackApplication rollbackApplication(array $options = [])
 * @method RunInstances runInstances(array $options = [])
 * @method RunServiceSchedule runServiceSchedule(array $options = [])
 * @method SaveSDG saveSDG(array $options = [])
 * @method SetBackendServers setBackendServers(array $options = [])
 * @method SetLoadBalancerHTTPListenerAttribute setLoadBalancerHTTPListenerAttribute(array $options = [])
 * @method SetLoadBalancerHTTPSListenerAttribute setLoadBalancerHTTPSListenerAttribute(array $options = [])
 * @method SetLoadBalancerStatus setLoadBalancerStatus(array $options = [])
 * @method SetLoadBalancerTCPListenerAttribute setLoadBalancerTCPListenerAttribute(array $options = [])
 * @method SetLoadBalancerUDPListenerAttribute setLoadBalancerUDPListenerAttribute(array $options = [])
 * @method StartEpnInstance startEpnInstance(array $options = [])
 * @method StartInstance startInstance(array $options = [])
 * @method StartInstances startInstances(array $options = [])
 * @method StartLoadBalancerListener startLoadBalancerListener(array $options = [])
 * @method StartSnatIpForSnatEntry startSnatIpForSnatEntry(array $options = [])
 * @method StopEpnInstance stopEpnInstance(array $options = [])
 * @method StopInstance stopInstance(array $options = [])
 * @method StopInstances stopInstances(array $options = [])
 * @method StopLoadBalancerListener stopLoadBalancerListener(array $options = [])
 * @method StopSnatIpForSnatEntry stopSnatIpForSnatEntry(array $options = [])
 * @method TagResources tagResources(array $options = [])
 * @method UnassignPrivateIpAddresses unassignPrivateIpAddresses(array $options = [])
 * @method UnAssociateEnsEipAddress unAssociateEnsEipAddress(array $options = [])
 * @method UnassociateHaVip unassociateHaVip(array $options = [])
 * @method UnassociateNetworkAcl unassociateNetworkAcl(array $options = [])
 * @method UnloadRegionSDG unloadRegionSDG(array $options = [])
 * @method UntagResources untagResources(array $options = [])
 * @method UpdateEnsSaleControl updateEnsSaleControl(array $options = [])
 * @method UpgradeAICInstanceImage upgradeAICInstanceImage(array $options = [])
 * @method UpgradeApplication upgradeApplication(array $options = [])
 */
class EnsApiResolver extends ApiResolver
{
}

class Rpc extends \AlibabaCloud\Client\Resolver\Rpc
{
    /** @var string */
    public $product = 'Ens';

    /** @var string */
    public $version = '2017-11-10';

    /** @var string */
    public $method = 'POST';

    /** @var string */
    public $serviceCode = 'ens';
}

/**
 * @method string getNetworkAclId()
 * @method $this withNetworkAclId($value)
 * @method string getResource()
 * @method $this withResource($value)
 */
class AccosicateNetworkAcl extends Rpc
{
}

/**
 * @method string getBackendServers()
 * @method $this withBackendServers($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 */
class AddBackendServers extends Rpc
{
}

/**
 * @method string getISP()
 * @method $this withISP($value)
 * @method string getInternalIp()
 * @method $this withInternalIp($value)
 * @method string getNatType()
 * @method $this withNatType($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getInternalPort()
 * @method $this withInternalPort($value)
 */
class AddDeviceInternetPort extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getNetworks()
 * @method $this withNetworks($value)
 * @method string getAutoStart()
 * @method $this withAutoStart($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class AddNetworkInterfaceToInstance extends Rpc
{
}

/**
 * @method string getSnatIp()
 * @method $this withSnatIp($value)
 * @method string getSnatEntryId()
 * @method $this withSnatEntryId($value)
 */
class AddSnatIpForSnatEntry extends Rpc
{
}

/**
 * @method string getVSwitchId()
 * @method $this withVSwitchId($value)
 * @method string getNetworkInterfaceId()
 * @method $this withNetworkInterfaceId($value)
 */
class AssignPrivateIpAddresses extends Rpc
{
}

/**
 * @method string getStandby()
 * @method $this withStandby($value)
 * @method string getAllocationId()
 * @method $this withAllocationId($value)
 * @method string getInstanceType()
 * @method $this withInstanceType($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class AssociateEnsEipAddress extends Rpc
{
}

/**
 * @method string getInstanceType()
 * @method $this withInstanceType($value)
 * @method string getHaVipId()
 * @method $this withHaVipId($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class AssociateHaVip extends Rpc
{
}

/**
 * @method string getDiskId()
 * @method $this withDiskId($value)
 * @method string getDeleteWithInstance()
 * @method $this withDeleteWithInstance($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class AttachDisk extends Rpc
{
}

/**
 * @method string getScripts()
 * @method $this withScripts($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class AttachEnsInstances extends Rpc
{
}

/**
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getNetworkInterfaceId()
 * @method $this withNetworkInterfaceId($value)
 */
class AttachNetworkInterface extends Rpc
{
}

/**
 * @method string getSourcePortRange()
 * @method $this withSourcePortRange($value)
 * @method string getPortRange()
 * @method $this withPortRange($value)
 * @method string getIpProtocol()
 * @method $this withIpProtocol($value)
 * @method string getSourceCidrIp()
 * @method $this withSourceCidrIp($value)
 * @method string getPriority()
 * @method $this withPriority($value)
 * @method string getSecurityGroupId()
 * @method $this withSecurityGroupId($value)
 * @method string getPolicy()
 * @method $this withPolicy($value)
 */
class AuthorizeSecurityGroup extends Rpc
{
}

/**
 * @method string getSourcePortRange()
 * @method $this withSourcePortRange($value)
 * @method string getPortRange()
 * @method $this withPortRange($value)
 * @method string getIpProtocol()
 * @method $this withIpProtocol($value)
 * @method string getPriority()
 * @method $this withPriority($value)
 * @method string getDestCidrIp()
 * @method $this withDestCidrIp($value)
 * @method string getSecurityGroupId()
 * @method $this withSecurityGroupId($value)
 * @method string getPolicy()
 * @method $this withPolicy($value)
 */
class AuthorizeSecurityGroupEgress extends Rpc
{
}

/**
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getDataName()
 * @method $this withDataName($value)
 * @method string getDataVersion()
 * @method $this withDataVersion($value)
 * @method string getAppId()
 * @method $this withAppId($value)
 */
class CleanDistData extends Rpc
{
}

/**
 * @method string getDestinationRegionIds()
 * @method $this withDestinationRegionIds($value)
 * @method string getSDGId()
 * @method $this withSDGId($value)
 */
class CopySDG extends Rpc
{

    /** @var string */
    public $scheme = 'https';

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getSnapshotId()
 * @method $this withSnapshotId($value)
 * @method string getDestinationRegionIds()
 * @method $this withDestinationRegionIds($value)
 * @method string getDestinationSnapshotName()
 * @method $this withDestinationSnapshotName($value)
 * @method string getDestinationSnapshotDescription()
 * @method $this withDestinationSnapshotDescription($value)
 */
class CopySnapshot extends Rpc
{
}

/**
 * @method string getTemplate()
 * @method $this withTemplate($value)
 * @method string getTimeout()
 * @method $this withTimeout($value)
 */
class CreateApplication extends Rpc
{
}

/**
 * @method string getKeyPairName()
 * @method $this withKeyPairName($value)
 * @method string getResolution()
 * @method $this withResolution($value)
 * @method string getFrequency()
 * @method $this withFrequency($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getPeriod()
 * @method $this withPeriod($value)
 * @method string getPeriodUnit()
 * @method $this withPeriodUnit($value)
 * @method string getAutoRenew()
 * @method $this withAutoRenew($value)
 * @method string getImageId()
 * @method $this withImageId($value)
 * @method string getServerType()
 * @method $this withServerType($value)
 * @method string getAutoUseCoupon()
 * @method $this withAutoUseCoupon($value)
 * @method string getInstanceType()
 * @method $this withInstanceType($value)
 * @method string getAmount()
 * @method $this withAmount($value)
 * @method string getNameSpace()
 * @method $this withNameSpace($value)
 * @method string getServerName()
 * @method $this withServerName($value)
 * @method string getPayType()
 * @method $this withPayType($value)
 */
class CreateARMServerInstances extends Rpc
{
}

/**
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getNetworkType()
 * @method $this withNetworkType($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getNetworkName()
 * @method $this withNetworkName($value)
 * @method string getCidrBlock()
 * @method $this withCidrBlock($value)
 */
class CreateClassicNetwork extends Rpc
{
}

/**
 * @method string getClusterVersion()
 * @method $this withClusterVersion($value)
 * @method string getName()
 * @method $this withName($value)
 */
class CreateCluster extends Rpc
{
}

/**
 * @method string getDiskName()
 * @method $this withDiskName($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method array getTag()
 * @method string getSize()
 * @method $this withSize($value)
 * @method string getSnapshotId()
 * @method $this withSnapshotId($value)
 * @method string getInstanceChargeType()
 * @method $this withInstanceChargeType($value)
 * @method string getEncrypted()
 * @method $this withEncrypted($value)
 * @method string getCategory()
 * @method $this withCategory($value)
 * @method string getKMSKeyId()
 * @method $this withKMSKeyId($value)
 */
class CreateDisk extends Rpc
{

    /**
     * @param array $tag
     *
     * @return $this
     */
	public function withTag(array $tag)
	{
	    $this->data['Tag'] = $tag;
		foreach ($tag as $depth1 => $depth1Value) {
			if(isset($depth1Value['Value'])){
				$this->options['query']['Tag.' . ($depth1 + 1) . '.Value'] = $depth1Value['Value'];
			}
			if(isset($depth1Value['Key'])){
				$this->options['query']['Tag.' . ($depth1 + 1) . '.Key'] = $depth1Value['Key'];
			}
		}

		return $this;
    }
}

/**
 * @method string getIsp()
 * @method $this withIsp($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method array getTag()
 * @method string getInternetChargeType()
 * @method $this withInternetChargeType($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getInstanceChargeType()
 * @method $this withInstanceChargeType($value)
 * @method string getBandwidth()
 * @method $this withBandwidth($value)
 */
class CreateEipInstance extends Rpc
{

    /**
     * @param array $tag
     *
     * @return $this
     */
	public function withTag(array $tag)
	{
	    $this->data['Tag'] = $tag;
		foreach ($tag as $depth1 => $depth1Value) {
			if(isset($depth1Value['Value'])){
				$this->options['query']['Tag.' . ($depth1 + 1) . '.Value'] = $depth1Value['Value'];
			}
			if(isset($depth1Value['Key'])){
				$this->options['query']['Tag.' . ($depth1 + 1) . '.Key'] = $depth1Value['Key'];
			}
		}

		return $this;
    }
}

/**
 * @method string getRouteEntryName()
 * @method $this withRouteEntryName($value)
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getNextHopId()
 * @method $this withNextHopId($value)
 * @method string getNextHopType()
 * @method $this withNextHopType($value)
 * @method string getRouteTableId()
 * @method $this withRouteTableId($value)
 * @method string getDestinationCidrBlock()
 * @method $this withDestinationCidrBlock($value)
 */
class CreateEnsRouteEntry extends Rpc
{
}

/**
 * @method string getSaleControls()
 * @method $this withSaleControls($value)
 * @method string getCustomAccount()
 * @method $this withCustomAccount($value)
 * @method string getCommodityCode()
 * @method $this withCommodityCode($value)
 * @method string getAliUidAccount()
 * @method $this withAliUidAccount($value)
 */
class CreateEnsSaleControl extends Rpc
{
}

/**
 * @method string getEnsServiceId()
 * @method $this withEnsServiceId($value)
 * @method string getOrderType()
 * @method $this withOrderType($value)
 */
class CreateEnsService extends Rpc
{
}

/**
 * @method string getNetworkingModel()
 * @method $this withNetworkingModel($value)
 * @method string getInternetMaxBandwidthOut()
 * @method $this withInternetMaxBandwidthOut($value)
 * @method string getEPNInstanceType()
 * @method $this withEPNInstanceType($value)
 * @method string getInternetChargeType()
 * @method $this withInternetChargeType($value)
 * @method string getEPNInstanceName()
 * @method $this withEPNInstanceName($value)
 */
class CreateEpnInstance extends Rpc
{
}

/**
 * @method string getOrderDetails()
 * @method $this withOrderDetails($value)
 */
class CreateFileSystem extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getInternalIp()
 * @method $this withInternalIp($value)
 * @method string getExternalIp()
 * @method $this withExternalIp($value)
 * @method string getIpProtocol()
 * @method $this withIpProtocol($value)
 * @method string getHealthCheckPort()
 * @method $this withHealthCheckPort($value)
 * @method string getExternalPort()
 * @method $this withExternalPort($value)
 * @method string getStandbyExternalIp()
 * @method $this withStandbyExternalIp($value)
 * @method string getNatGatewayId()
 * @method $this withNatGatewayId($value)
 * @method string getForwardEntryName()
 * @method $this withForwardEntryName($value)
 * @method string getInternalPort()
 * @method $this withInternalPort($value)
 */
class CreateForwardEntry extends Rpc
{
}

/**
 * @method string getSnapshotId()
 * @method $this withSnapshotId($value)
 * @method string getDeleteAfterImageUpload()
 * @method $this withDeleteAfterImageUpload($value)
 * @method string getImageName()
 * @method $this withImageName($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class CreateImage extends Rpc
{
}

/**
 * @method string getUniqueSuffix()
 * @method $this withUniqueSuffix($value)
 * @method string getKeyPairName()
 * @method $this withKeyPairName($value)
 * @method string getPassword()
 * @method $this withPassword($value)
 * @method string getHostName()
 * @method $this withHostName($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getAutoRenewPeriod()
 * @method $this withAutoRenewPeriod($value)
 * @method string getPeriod()
 * @method $this withPeriod($value)
 * @method string getPublicIpIdentification()
 * @method $this withPublicIpIdentification($value)
 * @method string getOwnerId()
 * @method $this withOwnerId($value)
 * @method string getVSwitchId()
 * @method $this withVSwitchId($value)
 * @method string getPrivateIpAddress()
 * @method $this withPrivateIpAddress($value)
 * @method string getInstanceName()
 * @method $this withInstanceName($value)
 * @method string getAutoRenew()
 * @method $this withAutoRenew($value)
 * @method string getInternetChargeType()
 * @method $this withInternetChargeType($value)
 * @method string getImageId()
 * @method $this withImageId($value)
 * @method string getUserData()
 * @method $this withUserData($value)
 * @method string getPasswordInherit()
 * @method $this withPasswordInherit($value)
 * @method string getInstanceType()
 * @method $this withInstanceType($value)
 * @method string getDataDisk1Size()
 * @method string getQuantity()
 * @method $this withQuantity($value)
 * @method string getIpType()
 * @method $this withIpType($value)
 * @method string getSystemDiskSize()
 * @method string getPaymentType()
 * @method $this withPaymentType($value)
 */
class CreateInstance extends Rpc
{

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withDataDisk1Size($value)
    {
        $this->data['DataDisk1Size'] = $value;
        $this->options['query']['DataDisk.1.Size'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withSystemDiskSize($value)
    {
        $this->data['SystemDiskSize'] = $value;
        $this->options['query']['SystemDisk.Size'] = $value;

        return $this;
    }
}

/**
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 */
class CreateInstanceActiveOpsTask extends Rpc
{
}

/**
 * @method string getKeyPairName()
 * @method $this withKeyPairName($value)
 */
class CreateKeyPair extends Rpc
{
}

/**
 * @method string getLoadBalancerName()
 * @method $this withLoadBalancerName($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getLoadBalancerSpec()
 * @method $this withLoadBalancerSpec($value)
 * @method string getVSwitchId()
 * @method $this withVSwitchId($value)
 * @method string getNetworkId()
 * @method $this withNetworkId($value)
 * @method string getPayType()
 * @method $this withPayType($value)
 */
class CreateLoadBalancer extends Rpc
{
}

/**
 * @method string getListenerForward()
 * @method $this withListenerForward($value)
 * @method string getHealthCheckTimeout()
 * @method $this withHealthCheckTimeout($value)
 * @method string getXForwardedFor()
 * @method $this withXForwardedFor($value)
 * @method string getHealthCheckURI()
 * @method $this withHealthCheckURI($value)
 * @method string getHealthCheck()
 * @method $this withHealthCheck($value)
 * @method string getProtocol()
 * @method $this withProtocol($value)
 * @method string getCookie()
 * @method $this withCookie($value)
 * @method string getHealthCheckMethod()
 * @method $this withHealthCheckMethod($value)
 * @method string getHealthCheckDomain()
 * @method $this withHealthCheckDomain($value)
 * @method string getRequestTimeout()
 * @method $this withRequestTimeout($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 * @method string getHealthCheckInterval()
 * @method $this withHealthCheckInterval($value)
 * @method string getBackendServerPort()
 * @method $this withBackendServerPort($value)
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getUnhealthyThreshold()
 * @method $this withUnhealthyThreshold($value)
 * @method string getHealthyThreshold()
 * @method $this withHealthyThreshold($value)
 * @method string getScheduler()
 * @method $this withScheduler($value)
 * @method string getForwardPort()
 * @method $this withForwardPort($value)
 * @method string getCookieTimeout()
 * @method $this withCookieTimeout($value)
 * @method string getStickySessionType()
 * @method $this withStickySessionType($value)
 * @method string getListenerPort()
 * @method $this withListenerPort($value)
 * @method string getStickySession()
 * @method $this withStickySession($value)
 * @method string getIdleTimeout()
 * @method $this withIdleTimeout($value)
 * @method string getHealthCheckConnectPort()
 * @method $this withHealthCheckConnectPort($value)
 * @method string getHealthCheckHttpCode()
 * @method $this withHealthCheckHttpCode($value)
 */
class CreateLoadBalancerHTTPListener extends Rpc
{
}

/**
 * @method string getListenerForward()
 * @method $this withListenerForward($value)
 * @method string getHealthCheckTimeout()
 * @method $this withHealthCheckTimeout($value)
 * @method string getHealthCheckURI()
 * @method $this withHealthCheckURI($value)
 * @method string getHealthCheck()
 * @method $this withHealthCheck($value)
 * @method string getProtocol()
 * @method $this withProtocol($value)
 * @method string getCookie()
 * @method $this withCookie($value)
 * @method string getHealthCheckMethod()
 * @method $this withHealthCheckMethod($value)
 * @method string getHealthCheckDomain()
 * @method $this withHealthCheckDomain($value)
 * @method string getRequestTimeout()
 * @method $this withRequestTimeout($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 * @method string getHealthCheckInterval()
 * @method $this withHealthCheckInterval($value)
 * @method string getBackendServerPort()
 * @method $this withBackendServerPort($value)
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getUnhealthyThreshold()
 * @method $this withUnhealthyThreshold($value)
 * @method string getHealthyThreshold()
 * @method $this withHealthyThreshold($value)
 * @method string getScheduler()
 * @method $this withScheduler($value)
 * @method string getForwardPort()
 * @method $this withForwardPort($value)
 * @method string getCookieTimeout()
 * @method $this withCookieTimeout($value)
 * @method string getStickySessionType()
 * @method $this withStickySessionType($value)
 * @method string getListenerPort()
 * @method $this withListenerPort($value)
 * @method string getStickySession()
 * @method $this withStickySession($value)
 * @method string getServerCertificateId()
 * @method $this withServerCertificateId($value)
 * @method string getIdleTimeout()
 * @method $this withIdleTimeout($value)
 * @method string getHealthCheckConnectPort()
 * @method $this withHealthCheckConnectPort($value)
 * @method string getHealthCheckHttpCode()
 * @method $this withHealthCheckHttpCode($value)
 */
class CreateLoadBalancerHTTPSListener extends Rpc
{
}

/**
 * @method string getHealthCheckURI()
 * @method $this withHealthCheckURI($value)
 * @method string getProtocol()
 * @method $this withProtocol($value)
 * @method string getEstablishedTimeout()
 * @method $this withEstablishedTimeout($value)
 * @method string getPersistenceTimeout()
 * @method $this withPersistenceTimeout($value)
 * @method string getHealthCheckDomain()
 * @method $this withHealthCheckDomain($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 * @method string getHealthCheckInterval()
 * @method $this withHealthCheckInterval($value)
 * @method string getBackendServerPort()
 * @method $this withBackendServerPort($value)
 * @method string getHealthCheckConnectTimeout()
 * @method $this withHealthCheckConnectTimeout($value)
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getUnhealthyThreshold()
 * @method $this withUnhealthyThreshold($value)
 * @method string getHealthyThreshold()
 * @method $this withHealthyThreshold($value)
 * @method string getScheduler()
 * @method $this withScheduler($value)
 * @method string getEipTransmit()
 * @method $this withEipTransmit($value)
 * @method string getListenerPort()
 * @method $this withListenerPort($value)
 * @method string getHealthCheckType()
 * @method $this withHealthCheckType($value)
 * @method string getHealthCheckHttpCode()
 * @method $this withHealthCheckHttpCode($value)
 * @method string getHealthCheckConnectPort()
 * @method $this withHealthCheckConnectPort($value)
 */
class CreateLoadBalancerTCPListener extends Rpc
{
}

/**
 * @method string getProtocol()
 * @method $this withProtocol($value)
 * @method string getEstablishedTimeout()
 * @method $this withEstablishedTimeout($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 * @method string getHealthCheckReq()
 * @method $this withHealthCheckReq($value)
 * @method string getHealthCheckInterval()
 * @method $this withHealthCheckInterval($value)
 * @method string getBackendServerPort()
 * @method $this withBackendServerPort($value)
 * @method string getHealthCheckExp()
 * @method $this withHealthCheckExp($value)
 * @method string getHealthCheckConnectTimeout()
 * @method $this withHealthCheckConnectTimeout($value)
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getUnhealthyThreshold()
 * @method $this withUnhealthyThreshold($value)
 * @method string getHealthyThreshold()
 * @method $this withHealthyThreshold($value)
 * @method string getScheduler()
 * @method $this withScheduler($value)
 * @method string getEipTransmit()
 * @method $this withEipTransmit($value)
 * @method string getListenerPort()
 * @method $this withListenerPort($value)
 * @method string getHealthCheckConnectPort()
 * @method $this withHealthCheckConnectPort($value)
 */
class CreateLoadBalancerUDPListener extends Rpc
{
}

/**
 * @method string getMountTargetName()
 * @method $this withMountTargetName($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getFileSystemId()
 * @method $this withFileSystemId($value)
 * @method string getNetWorkId()
 * @method $this withNetWorkId($value)
 */
class CreateMountTarget extends Rpc
{
}

/**
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getInstanceType()
 * @method $this withInstanceType($value)
 * @method array getTag()
 * @method string getVSwitchId()
 * @method $this withVSwitchId($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getNetworkId()
 * @method $this withNetworkId($value)
 */
class CreateNatGateway extends Rpc
{

    /**
     * @param array $tag
     *
     * @return $this
     */
	public function withTag(array $tag)
	{
	    $this->data['Tag'] = $tag;
		foreach ($tag as $depth1 => $depth1Value) {
			if(isset($depth1Value['Value'])){
				$this->options['query']['Tag.' . ($depth1 + 1) . '.Value'] = $depth1Value['Value'];
			}
			if(isset($depth1Value['Key'])){
				$this->options['query']['Tag.' . ($depth1 + 1) . '.Key'] = $depth1Value['Key'];
			}
		}

		return $this;
    }
}

/**
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getNetworkName()
 * @method $this withNetworkName($value)
 * @method array getTag()
 * @method string getCidrBlock()
 * @method $this withCidrBlock($value)
 */
class CreateNetwork extends Rpc
{

    /**
     * @param array $tag
     *
     * @return $this
     */
	public function withTag(array $tag)
	{
	    $this->data['Tag'] = $tag;
		foreach ($tag as $depth1 => $depth1Value) {
			if(isset($depth1Value['Value'])){
				$this->options['query']['Tag.' . ($depth1 + 1) . '.Value'] = $depth1Value['Value'];
			}
			if(isset($depth1Value['Key'])){
				$this->options['query']['Tag.' . ($depth1 + 1) . '.Key'] = $depth1Value['Key'];
			}
		}

		return $this;
    }
}

/**
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getNetworkAclName()
 * @method $this withNetworkAclName($value)
 */
class CreateNetworkAcl extends Rpc
{
}

/**
 * @method string getNetworkAclEntryName()
 * @method $this withNetworkAclEntryName($value)
 * @method string getProtocol()
 * @method $this withProtocol($value)
 * @method string getPortRange()
 * @method $this withPortRange($value)
 * @method string getPriority()
 * @method $this withPriority($value)
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getNetworkAclId()
 * @method $this withNetworkAclId($value)
 * @method string getDirection()
 * @method $this withDirection($value)
 * @method string getPolicy()
 * @method $this withPolicy($value)
 * @method string getCidrBlock()
 * @method $this withCidrBlock($value)
 */
class CreateNetworkAclEntry extends Rpc
{
}

/**
 * @method string getFromSDGId()
 * @method $this withFromSDGId($value)
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getSize()
 * @method $this withSize($value)
 */
class CreateSDG extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getSecurityGroupName()
 * @method $this withSecurityGroupName($value)
 */
class CreateSecurityGroup extends Rpc
{
}

/**
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getSnapshotName()
 * @method $this withSnapshotName($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getDiskId()
 * @method $this withDiskId($value)
 */
class CreateSnapshot extends Rpc
{
}

/**
 * @method string getSnatIp()
 * @method $this withSnatIp($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getDestCIDR()
 * @method $this withDestCIDR($value)
 * @method string getSourceVSwitchId()
 * @method $this withSourceVSwitchId($value)
 * @method string getSourceNetworkId()
 * @method $this withSourceNetworkId($value)
 * @method string getStandbySnatIp()
 * @method $this withStandbySnatIp($value)
 * @method string getSourceCIDR()
 * @method $this withSourceCIDR($value)
 * @method string getNatGatewayId()
 * @method $this withNatGatewayId($value)
 * @method string getIdleTimeout()
 * @method $this withIdleTimeout($value)
 * @method string getSnatEntryName()
 * @method $this withSnatEntryName($value)
 */
class CreateSnatEntry extends Rpc
{
}

/**
 * @method string getOrderDetails()
 * @method $this withOrderDetails($value)
 */
class CreateStorageGateway extends Rpc
{
}

/**
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getGatewayId()
 * @method $this withGatewayId($value)
 * @method string getAuthUser()
 * @method $this withAuthUser($value)
 * @method string getVolumeName()
 * @method $this withVolumeName($value)
 * @method string getAuthPassword()
 * @method $this withAuthPassword($value)
 * @method string getAuthProtocol()
 * @method $this withAuthProtocol($value)
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getIsEnable()
 * @method $this withIsEnable($value)
 * @method string getIsAuth()
 * @method $this withIsAuth($value)
 * @method string getStorageId()
 * @method $this withStorageId($value)
 */
class CreateStorageVolume extends Rpc
{
}

/**
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method array getTag()
 * @method string getVSwitchName()
 * @method $this withVSwitchName($value)
 * @method string getCidrBlock()
 * @method $this withCidrBlock($value)
 * @method string getNetworkId()
 * @method $this withNetworkId($value)
 */
class CreateVSwitch extends Rpc
{

    /**
     * @param array $tag
     *
     * @return $this
     */
	public function withTag(array $tag)
	{
	    $this->data['Tag'] = $tag;
		foreach ($tag as $depth1 => $depth1Value) {
			if(isset($depth1Value['Value'])){
				$this->options['query']['Tag.' . ($depth1 + 1) . '.Value'] = $depth1Value['Value'];
			}
			if(isset($depth1Value['Key'])){
				$this->options['query']['Tag.' . ($depth1 + 1) . '.Key'] = $depth1Value['Key'];
			}
		}

		return $this;
    }
}

/**
 * @method string getTimeout()
 * @method $this withTimeout($value)
 * @method string getAppId()
 * @method $this withAppId($value)
 */
class DeleteApplication extends Rpc
{
}

/**
 * @method string getBucketName()
 * @method $this withBucketName($value)
 */
class DeleteBucket extends Rpc
{
}

/**
 * @method string getBucketName()
 * @method $this withBucketName($value)
 * @method string getRuleId()
 * @method $this withRuleId($value)
 */
class DeleteBucketLifecycle extends Rpc
{
}

/**
 * @method string getNatType()
 * @method $this withNatType($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getRuleId()
 * @method $this withRuleId($value)
 */
class DeleteDeviceInternetPort extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getDiskId()
 * @method $this withDiskId($value)
 */
class DeleteDisk extends Rpc
{
}

/**
 * @method string getRouteEntryId()
 * @method $this withRouteEntryId($value)
 */
class DeleteEnsRouteEntry extends Rpc
{
}

/**
 * @method string getSaleControls()
 * @method $this withSaleControls($value)
 * @method string getCustomAccount()
 * @method $this withCustomAccount($value)
 * @method string getCommodityCode()
 * @method $this withCommodityCode($value)
 * @method string getAliUidAccount()
 * @method $this withAliUidAccount($value)
 */
class DeleteEnsSaleConditionControl extends Rpc
{
}

/**
 * @method string getSaleControls()
 * @method $this withSaleControls($value)
 * @method string getCustomAccount()
 * @method $this withCustomAccount($value)
 * @method string getCommodityCode()
 * @method $this withCommodityCode($value)
 * @method string getAliUidAccount()
 * @method $this withAliUidAccount($value)
 */
class DeleteEnsSaleControl extends Rpc
{
}

/**
 * @method string getEPNInstanceId()
 * @method $this withEPNInstanceId($value)
 */
class DeleteEpnInstance extends Rpc
{
}

/**
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getFileSystemId()
 * @method $this withFileSystemId($value)
 */
class DeleteFileSystem extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getForwardEntryId()
 * @method $this withForwardEntryId($value)
 */
class DeleteForwardEntry extends Rpc
{
}

/**
 * @method string getImageId()
 * @method $this withImageId($value)
 */
class DeleteImage extends Rpc
{
}

/**
 * @method string getKeyPairName()
 * @method $this withKeyPairName($value)
 * @method string getKeyPairId()
 * @method $this withKeyPairId($value)
 */
class DeleteKeyPairs extends Rpc
{
}

/**
 * @method string getListenerPort()
 * @method $this withListenerPort($value)
 * @method string getListenerProtocol()
 * @method $this withListenerProtocol($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 */
class DeleteLoadBalancerListener extends Rpc
{
}

/**
 * @method string getMountTargetName()
 * @method $this withMountTargetName($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getFileSystemId()
 * @method $this withFileSystemId($value)
 */
class DeleteMountTarget extends Rpc
{
}

/**
 * @method string getNatGatewayId()
 * @method $this withNatGatewayId($value)
 */
class DeleteNatGateway extends Rpc
{
}

/**
 * @method string getNetworkId()
 * @method $this withNetworkId($value)
 */
class DeleteNetwork extends Rpc
{
}

/**
 * @method string getNetworkAclId()
 * @method $this withNetworkAclId($value)
 */
class DeleteNetworkAcl extends Rpc
{
}

/**
 * @method string getNetworkAclEntryId()
 * @method $this withNetworkAclEntryId($value)
 */
class DeleteNetworkAclEntry extends Rpc
{
}

/**
 * @method string getBucketName()
 * @method $this withBucketName($value)
 * @method string getObjectKey()
 * @method $this withObjectKey($value)
 */
class DeleteObject extends Rpc
{
}

/**
 * @method string getSDGId()
 * @method $this withSDGId($value)
 */
class DeleteSDG extends Rpc
{
}

/**
 * @method string getSecurityGroupId()
 * @method $this withSecurityGroupId($value)
 */
class DeleteSecurityGroup extends Rpc
{
}

/**
 * @method string getSnapshotId()
 * @method $this withSnapshotId($value)
 */
class DeleteSnapshot extends Rpc
{
}

/**
 * @method string getSnatEntryId()
 * @method $this withSnatEntryId($value)
 */
class DeleteSnatEntry extends Rpc
{
}

/**
 * @method string getSnatIp()
 * @method $this withSnatIp($value)
 * @method string getSnatEntryId()
 * @method $this withSnatEntryId($value)
 */
class DeleteSnatIpForSnatEntry extends Rpc
{
}

/**
 * @method string getGatewayId()
 * @method $this withGatewayId($value)
 */
class DeleteStorageGateway extends Rpc
{
}

/**
 * @method string getVolumeId()
 * @method $this withVolumeId($value)
 */
class DeleteStorageVolume extends Rpc
{
}

/**
 * @method string getVSwitchId()
 * @method $this withVSwitchId($value)
 */
class DeleteVSwitch extends Rpc
{
}

/**
 * @method string getDeploymentType()
 * @method $this withDeploymentType($value)
 * @method string getSDGId()
 * @method $this withSDGId($value)
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 */
class DeployInstanceSDG extends Rpc
{
}

/**
 * @method string getDeploymentType()
 * @method $this withDeploymentType($value)
 * @method string getSDGId()
 * @method $this withSDGId($value)
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 */
class DeploySDG extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getImageType()
 * @method $this withImageType($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 * @method string getImageId()
 * @method $this withImageId($value)
 * @method string getMaxDate()
 * @method $this withMaxDate($value)
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getMinDate()
 * @method $this withMinDate($value)
 * @method string getImageUrl()
 * @method $this withImageUrl($value)
 */
class DescribeAICImages extends Rpc
{
}

/**
 * @method string getResourceSelector()
 * @method $this withResourceSelector($value)
 * @method string getAppVersions()
 * @method $this withAppVersions($value)
 * @method string getOutDetailStatParams()
 * @method $this withOutDetailStatParams($value)
 * @method string getLevel()
 * @method $this withLevel($value)
 * @method string getAppId()
 * @method $this withAppId($value)
 */
class DescribeApplication extends Rpc
{
}

/**
 * @method string getAICSpecs()
 * @method $this withAICSpecs($value)
 * @method string getOrderByParams()
 * @method $this withOrderByParams($value)
 * @method string getDescribeAICInstances()
 * @method $this withDescribeAICInstances($value)
 * @method string getServerIds()
 * @method $this withServerIds($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getMaxDate()
 * @method $this withMaxDate($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getStates()
 * @method $this withStates($value)
 * @method string getServerSpecs()
 * @method $this withServerSpecs($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getEnsRegionIds()
 * @method $this withEnsRegionIds($value)
 * @method string getMinDate()
 * @method $this withMinDate($value)
 * @method string getNamespace()
 * @method $this withNamespace($value)
 */
class DescribeARMServerInstances extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

class DescribeAvailableResource extends Rpc
{
}

class DescribeAvailableResourceInfo extends Rpc
{
}

/**
 * @method string getIsp()
 * @method $this withIsp($value)
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 */
class DescribeBandwitdhByInternetChargeType extends Rpc
{
}

class DescribeBandWithdChargeType extends Rpc
{
}

class DescribeCloudDiskAvailableResourceInfo extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getEnsRegionIds()
 * @method $this withEnsRegionIds($value)
 */
class DescribeCloudDiskTypes extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getClusterId()
 * @method $this withClusterId($value)
 */
class DescribeCluster extends Rpc
{
}

/**
 * @method string getClusterId()
 * @method $this withClusterId($value)
 */
class DescribeClusterKubeConfig extends Rpc
{
}

/**
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class DescribeCreatePrePaidInstanceResult extends Rpc
{
}

/**
 * @method string getDataVersions()
 * @method $this withDataVersions($value)
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 * @method string getMaxDate()
 * @method $this withMaxDate($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getEnsRegionIds()
 * @method $this withEnsRegionIds($value)
 * @method string getMinDate()
 * @method $this withMinDate($value)
 * @method string getAppId()
 * @method $this withAppId($value)
 * @method string getDataNames()
 * @method $this withDataNames($value)
 */
class DescribeDataDistResult extends Rpc
{
}

/**
 * @method string getExpireTimeout()
 * @method $this withExpireTimeout($value)
 * @method string getServerFilterStrategy()
 * @method $this withServerFilterStrategy($value)
 * @method string getDataName()
 * @method $this withDataName($value)
 * @method string getDataVersion()
 * @method $this withDataVersion($value)
 * @method string getAppId()
 * @method $this withAppId($value)
 */
class DescribeDataDownloadURL extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getRegionIds()
 * @method $this withRegionIds($value)
 * @method string getDataVersions()
 * @method $this withDataVersions($value)
 * @method string getMaxDate()
 * @method $this withMaxDate($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getMinDate()
 * @method $this withMinDate($value)
 * @method string getAppId()
 * @method $this withAppId($value)
 * @method string getDataNames()
 * @method $this withDataNames($value)
 */
class DescribeDataPushResult extends Rpc
{
}

/**
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getOrderId()
 * @method $this withOrderId($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getAppId()
 * @method $this withAppId($value)
 * @method string getServiceId()
 * @method $this withServiceId($value)
 */
class DescribeDeviceService extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getDiskId()
 * @method $this withDiskId($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 */
class DescribeDiskIopsList extends Rpc
{

    /** @var string */
    public $scheme = 'https';

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getOrderByParams()
 * @method $this withOrderByParams($value)
 * @method string getDiskName()
 * @method $this withDiskName($value)
 * @method string getDiskChargeType()
 * @method $this withDiskChargeType($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 * @method string getSnapshotId()
 * @method $this withSnapshotId($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getDiskIds()
 * @method $this withDiskIds($value)
 * @method string getDiskId()
 * @method $this withDiskId($value)
 * @method string getEnsRegionIds()
 * @method $this withEnsRegionIds($value)
 * @method string getDiskType()
 * @method $this withDiskType($value)
 * @method string getCategory()
 * @method $this withCategory($value)
 */
class DescribeDisks extends Rpc
{
}

class DescribeElbAvailableResourceInfo extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getCommodityCode()
 * @method $this withCommodityCode($value)
 */
class DescribeEnsCommodityCode extends Rpc
{
}

/**
 * @method string getCommodityCode()
 * @method $this withCommodityCode($value)
 * @method string getModuleCode()
 * @method $this withModuleCode($value)
 */
class DescribeEnsCommodityModuleCode extends Rpc
{
}

/**
 * @method string getEipName()
 * @method $this withEipName($value)
 * @method string getEipAddress()
 * @method $this withEipAddress($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 * @method string getStandby()
 * @method $this withStandby($value)
 * @method string getAllocationId()
 * @method $this withAllocationId($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getAssociatedInstanceType()
 * @method $this withAssociatedInstanceType($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getAssociatedInstanceId()
 * @method $this withAssociatedInstanceId($value)
 */
class DescribeEnsEipAddresses extends Rpc
{
}

/**
 * @method string getNetLevelCode()
 * @method $this withNetLevelCode($value)
 * @method string getNetDistrictCode()
 * @method $this withNetDistrictCode($value)
 */
class DescribeEnsNetDistrict extends Rpc
{
}

class DescribeEnsNetLevel extends Rpc
{
}

/**
 * @method string getNetLevelCode()
 * @method $this withNetLevelCode($value)
 * @method string getNetDistrictCode()
 * @method $this withNetDistrictCode($value)
 */
class DescribeEnsNetSaleDistrict extends Rpc
{
}

/**
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 */
class DescribeEnsRegionIdIpv6Info extends Rpc
{
}

/**
 * @method string getIsp()
 * @method $this withIsp($value)
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getOrderByParams()
 * @method $this withOrderByParams($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 */
class DescribeEnsRegionIdResource extends Rpc
{
}

/**
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 */
class DescribeEnsRegions extends Rpc
{
}

/**
 * @method string getExpiredStartTime()
 * @method $this withExpiredStartTime($value)
 * @method string getExpiredEndTime()
 * @method $this withExpiredEndTime($value)
 */
class DescribeEnsResourceUsage extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getRouteEntryName()
 * @method $this withRouteEntryName($value)
 * @method string getNextHopId()
 * @method $this withNextHopId($value)
 * @method string getNextHopType()
 * @method $this withNextHopType($value)
 * @method string getRouteTableId()
 * @method $this withRouteTableId($value)
 * @method string getDestinationCidrBlock()
 * @method $this withDestinationCidrBlock($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getRouteEntryType()
 * @method $this withRouteEntryType($value)
 * @method string getRouteEntryId()
 * @method $this withRouteEntryId($value)
 */
class DescribeEnsRouteEntryList extends Rpc
{
}

/**
 * @method string getCustomAccount()
 * @method $this withCustomAccount($value)
 * @method string getCommodityCode()
 * @method $this withCommodityCode($value)
 * @method string getModuleCode()
 * @method $this withModuleCode($value)
 * @method string getAliUidAccount()
 * @method $this withAliUidAccount($value)
 * @method string getOrderType()
 * @method $this withOrderType($value)
 */
class DescribeEnsSaleControl extends Rpc
{
}

/**
 * @method string getCustomAccount()
 * @method $this withCustomAccount($value)
 * @method string getCommodityCode()
 * @method $this withCommodityCode($value)
 * @method string getOrderType()
 * @method $this withOrderType($value)
 */
class DescribeEnsSaleControlAvailableResource extends Rpc
{
}

/**
 * @method string getCustomAccount()
 * @method $this withCustomAccount($value)
 * @method string getCommodityCode()
 * @method $this withCommodityCode($value)
 * @method string getModuleCode()
 * @method $this withModuleCode($value)
 * @method string getAliUidAccount()
 * @method $this withAliUidAccount($value)
 * @method string getOrderType()
 * @method $this withOrderType($value)
 */
class DescribeEnsSaleControlStock extends Rpc
{
}

/**
 * @method string getIsp()
 * @method $this withIsp($value)
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getEPNInstanceId()
 * @method $this withEPNInstanceId($value)
 * @method string getPeriod()
 * @method $this withPeriod($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getNetworkingModel()
 * @method $this withNetworkingModel($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 */
class DescribeEpnBandWidthData extends Rpc
{
}

/**
 * @method string getNetworkingModel()
 * @method $this withNetworkingModel($value)
 * @method string getIsp()
 * @method $this withIsp($value)
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 */
class DescribeEpnBandwitdhByInternetChargeType extends Rpc
{
}

/**
 * @method string getEPNInstanceId()
 * @method $this withEPNInstanceId($value)
 */
class DescribeEpnInstanceAttribute extends Rpc
{
}

/**
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getEPNInstanceId()
 * @method $this withEPNInstanceId($value)
 * @method string getEPNInstanceName()
 * @method $this withEPNInstanceName($value)
 */
class DescribeEpnInstances extends Rpc
{
}

/**
 * @method string getStartDate()
 * @method $this withStartDate($value)
 * @method string getEndDate()
 * @method $this withEndDate($value)
 */
class DescribeEpnMeasurementData extends Rpc
{
}

/**
 * @method string getImageId()
 * @method $this withImageId($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getImageName()
 * @method $this withImageName($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeExportImageInfo extends Rpc
{
}

/**
 * @method string getImageId()
 * @method $this withImageId($value)
 */
class DescribeExportImageStatus extends Rpc
{
}

/**
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getFileSystemName()
 * @method $this withFileSystemName($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getFileSystemId()
 * @method $this withFileSystemId($value)
 */
class DescribeFileSystems extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getInternalIp()
 * @method $this withInternalIp($value)
 * @method string getExternalIp()
 * @method $this withExternalIp($value)
 * @method string getIpProtocol()
 * @method $this withIpProtocol($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getShowDetail()
 * @method $this withShowDetail($value)
 * @method string getForwardEntryId()
 * @method $this withForwardEntryId($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getNatGatewayId()
 * @method $this withNatGatewayId($value)
 * @method string getForwardEntryName()
 * @method $this withForwardEntryName($value)
 */
class DescribeForwardTableEntries extends Rpc
{
}

/**
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getHaVipId()
 * @method $this withHaVipId($value)
 * @method string getHaVipAddress()
 * @method $this withHaVipAddress($value)
 * @method string getVSwitchId()
 * @method $this withVSwitchId($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getNetworkId()
 * @method $this withNetworkId($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeHaVips extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getOsType()
 * @method $this withOsType($value)
 */
class DescribeImageInfos extends Rpc
{
}

/**
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 * @method string getImageId()
 * @method $this withImageId($value)
 * @method string getSnapshotId()
 * @method $this withSnapshotId($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getImageName()
 * @method $this withImageName($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeImages extends Rpc
{
}

/**
 * @method string getImageId()
 * @method $this withImageId($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getAliyunId()
 * @method $this withAliyunId($value)
 */
class DescribeImageSharePermission extends Rpc
{
}

/**
 * @method string getOwnerId()
 * @method $this withOwnerId($value)
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 */
class DescribeInstanceAutoRenewAttribute extends Rpc
{
}

/**
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getInstanceType()
 * @method $this withInstanceType($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getServiceType()
 * @method $this withServiceType($value)
 */
class DescribeInstanceBandwidthDetail extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getPeriod()
 * @method $this withPeriod($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class DescribeInstanceMonitorData extends Rpc
{
}

/**
 * @method string getOrderByParams()
 * @method $this withOrderByParams($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getInstanceResourceType()
 * @method $this withInstanceResourceType($value)
 * @method string getEnsServiceId()
 * @method $this withEnsServiceId($value)
 * @method string getTags()
 * @method $this withTags($value)
 * @method string getVSwitchId()
 * @method $this withVSwitchId($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getInstanceName()
 * @method $this withInstanceName($value)
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 * @method string getNetworkId()
 * @method $this withNetworkId($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 * @method string getIntranetIp()
 * @method $this withIntranetIp($value)
 * @method string getImageId()
 * @method $this withImageId($value)
 * @method string getSecurityGroupId()
 * @method $this withSecurityGroupId($value)
 * @method string getSearchKey()
 * @method $this withSearchKey($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getInstanceType()
 * @method $this withInstanceType($value)
 * @method string getEnsRegionIds()
 * @method $this withEnsRegionIds($value)
 */
class DescribeInstances extends Rpc
{
}

class DescribeInstanceSpec extends Rpc
{
}

class DescribeInstanceTypes extends Rpc
{
}

/**
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class DescribeInstanceVncUrl extends Rpc
{
}

/**
 * @method string getKeyPairName()
 * @method $this withKeyPairName($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getKeyPairId()
 * @method $this withKeyPairId($value)
 */
class DescribeKeyPairs extends Rpc
{
}

/**
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 */
class DescribeLoadBalancerAttribute extends Rpc
{
}

/**
 * @method string getProtocol()
 * @method $this withProtocol($value)
 * @method string getListenerPort()
 * @method $this withListenerPort($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 */
class DescribeLoadBalancerHTTPListenerAttribute extends Rpc
{
}

/**
 * @method string getProtocol()
 * @method $this withProtocol($value)
 * @method string getListenerPort()
 * @method $this withListenerPort($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 */
class DescribeLoadBalancerHTTPSListenerAttribute extends Rpc
{
}

/**
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 */
class DescribeLoadBalancerListeners extends Rpc
{
}

/**
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 * @method string getProto()
 * @method $this withProto($value)
 * @method string getVPort()
 * @method $this withVPort($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 */
class DescribeLoadBalancerListenMonitor extends Rpc
{

    /** @var string */
    public $scheme = 'https';

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getLoadBalancerName()
 * @method $this withLoadBalancerName($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getServerId()
 * @method $this withServerId($value)
 * @method string getVSwitchId()
 * @method $this withVSwitchId($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 * @method string getNetworkId()
 * @method $this withNetworkId($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getAddress()
 * @method $this withAddress($value)
 * @method string getLoadBalancerStatus()
 * @method $this withLoadBalancerStatus($value)
 */
class DescribeLoadBalancers extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getLoadBalancerSpec()
 * @method $this withLoadBalancerSpec($value)
 */
class DescribeLoadBalancerSpec extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getProtocol()
 * @method $this withProtocol($value)
 * @method string getListenerPort()
 * @method $this withListenerPort($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 */
class DescribeLoadBalancerTCPListenerAttribute extends Rpc
{
}

/**
 * @method string getProtocol()
 * @method $this withProtocol($value)
 * @method string getListenerPort()
 * @method $this withListenerPort($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 */
class DescribeLoadBalancerUDPListenerAttribute extends Rpc
{
}

/**
 * @method string getStartDate()
 * @method $this withStartDate($value)
 * @method string getEndDate()
 * @method $this withEndDate($value)
 */
class DescribeMeasurementData extends Rpc
{
}

/**
 * @method string getMountTargetName()
 * @method $this withMountTargetName($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getFileSystemId()
 * @method $this withFileSystemId($value)
 */
class DescribeMountTargets extends Rpc
{
}

/**
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getVSwitchId()
 * @method $this withVSwitchId($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getNetworkId()
 * @method $this withNetworkId($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getNatGatewayId()
 * @method $this withNatGatewayId($value)
 */
class DescribeNatGateways extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getResourceId()
 * @method $this withResourceId($value)
 * @method string getOpenapiCheck()
 * @method $this withOpenapiCheck($value)
 */
class DescribeNCInformation extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getNetworkAclId()
 * @method $this withNetworkAclId($value)
 * @method string getResourceId()
 * @method $this withResourceId($value)
 * @method string getNetworkAclName()
 * @method $this withNetworkAclName($value)
 */
class DescribeNetworkAcls extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getNetworkId()
 * @method $this withNetworkId($value)
 */
class DescribeNetworkAttribute extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getNetworkInterfaceName()
 * @method $this withNetworkInterfaceName($value)
 * @method string getVSwitchId()
 * @method $this withVSwitchId($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getNetworkId()
 * @method $this withNetworkId($value)
 * @method string getIpv6Address()
 * @method $this withIpv6Address($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 * @method string getSecurityGroupId()
 * @method $this withSecurityGroupId($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getShowDetail()
 * @method $this withShowDetail($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getPrimaryIpAddress()
 * @method $this withPrimaryIpAddress($value)
 * @method string getNetworkInterfaceId()
 * @method $this withNetworkInterfaceId($value)
 */
class DescribeNetworkInterfaces extends Rpc
{
}

/**
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getNetworkName()
 * @method $this withNetworkName($value)
 * @method string getNetworkId()
 * @method $this withNetworkId($value)
 */
class DescribeNetworks extends Rpc
{
}

/**
 * @method string getInstanceSpec()
 * @method $this withInstanceSpec($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getSystemDiskSize()
 * @method $this withSystemDiskSize($value)
 * @method string getDataDiskSize()
 * @method $this withDataDiskSize($value)
 */
class DescribePrePaidInstanceStock extends Rpc
{
}

/**
 * @method string getDataDisks()
 * @method $this withDataDisks($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getPeriod()
 * @method $this withPeriod($value)
 * @method string getPeriodUnit()
 * @method $this withPeriodUnit($value)
 * @method string getInternetChargeType()
 * @method $this withInternetChargeType($value)
 * @method string getInstanceType()
 * @method $this withInstanceType($value)
 * @method string getDataDisk1Size()
 * @method string getQuantity()
 * @method $this withQuantity($value)
 * @method string getSystemDiskSize()
 */
class DescribePrice extends Rpc
{

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withDataDisk1Size($value)
    {
        $this->data['DataDisk1Size'] = $value;
        $this->options['query']['DataDisk.1.Size'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withSystemDiskSize($value)
    {
        $this->data['SystemDiskSize'] = $value;
        $this->options['query']['SystemDisk.Size'] = $value;

        return $this;
    }
}

/**
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 */
class DescribeRegionIsps extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getIspType()
 * @method $this withIspType($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getOpenapiCheck()
 * @method $this withOpenapiCheck($value)
 */
class DescribeRegionResource extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

class DescribeReservedResource extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getBeginTime()
 * @method $this withBeginTime($value)
 * @method string getOpenapiCheck()
 * @method $this withOpenapiCheck($value)
 */
class DescribeResourceTimeline extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getSDGIds()
 * @method $this withSDGIds($value)
 */
class DescribeSDG extends Rpc
{
}

/**
 * @method string getRegionIds()
 * @method $this withRegionIds($value)
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 * @method string getDeploymentType()
 * @method $this withDeploymentType($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getSDGId()
 * @method $this withSDGId($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeSDGDeploymentStatus extends Rpc
{

    /** @var string */
    public $scheme = 'https';
}

/**
 * @method string getSDGIds()
 * @method $this withSDGIds($value)
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 */
class DescribeSDGs extends Rpc
{
}

/**
 * @method string getSecondaryPublicIpId()
 * @method $this withSecondaryPublicIpId($value)
 * @method string getIsp()
 * @method $this withIsp($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getSecondaryPublicIpAddress()
 * @method $this withSecondaryPublicIpAddress($value)
 */
class DescribeSecondaryPublicIpAddresses extends Rpc
{
}

/**
 * @method string getSecurityGroupId()
 * @method $this withSecurityGroupId($value)
 */
class DescribeSecurityGroupAttribute extends Rpc
{
}

/**
 * @method string getSecurityGroupId()
 * @method $this withSecurityGroupId($value)
 * @method string getSecurityGroupName()
 * @method $this withSecurityGroupName($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeSecurityGroups extends Rpc
{
}

/**
 * @method string getImageId()
 * @method $this withImageId($value)
 * @method string getSnapshotId()
 * @method $this withSnapshotId($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getImageName()
 * @method $this withImageName($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeSelfImages extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getPodConfigName()
 * @method $this withPodConfigName($value)
 * @method string getAppId()
 * @method $this withAppId($value)
 */
class DescribeServcieSchedule extends Rpc
{
}

/**
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 * @method string getProto()
 * @method $this withProto($value)
 * @method string getVPort()
 * @method $this withVPort($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 */
class DescribeServerLoadBalancerListenMonitor extends Rpc
{

    /** @var string */
    public $scheme = 'https';

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 */
class DescribeServerLoadBalancerMonitor extends Rpc
{

    /** @var string */
    public $scheme = 'https';

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getSnapshotId()
 * @method $this withSnapshotId($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getDiskId()
 * @method $this withDiskId($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class DescribeSnapshots extends Rpc
{
}

/**
 * @method string getSnatEntryId()
 * @method $this withSnatEntryId($value)
 */
class DescribeSnatAttribute extends Rpc
{
}

/**
 * @method string getSnatIp()
 * @method $this withSnatIp($value)
 * @method string getSnatEntryId()
 * @method $this withSnatEntryId($value)
 * @method string getSourceCIDR()
 * @method $this withSourceCIDR($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getShowDetail()
 * @method $this withShowDetail($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getNatGatewayId()
 * @method $this withNatGatewayId($value)
 * @method string getSnatEntryName()
 * @method $this withSnatEntryName($value)
 */
class DescribeSnatTableEntries extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getGatewayId()
 * @method $this withGatewayId($value)
 * @method string getGatewayType()
 * @method $this withGatewayType($value)
 * @method string getVpcId()
 * @method $this withVpcId($value)
 */
class DescribeStorageGateway extends Rpc
{
}

/**
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getGatewayId()
 * @method $this withGatewayId($value)
 * @method string getVolumeId()
 * @method $this withVolumeId($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getIsEnable()
 * @method $this withIsEnable($value)
 * @method string getStorageId()
 * @method $this withStorageId($value)
 */
class DescribeStorageVolume extends Rpc
{
}

/**
 * @method string getIsp()
 * @method $this withIsp($value)
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getPeriod()
 * @method $this withPeriod($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class DescribeUserBandWidthData extends Rpc
{
}

/**
 * @method string getOrderByParams()
 * @method $this withOrderByParams($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getVSwitchId()
 * @method $this withVSwitchId($value)
 * @method string getNetworkId()
 * @method $this withNetworkId($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getVSwitchName()
 * @method $this withVSwitchName($value)
 */
class DescribeVSwitches extends Rpc
{
}

/**
 * @method string getDiskId()
 * @method $this withDiskId($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class DetachDisk extends Rpc
{
}

/**
 * @method string getNetworkInterfaceId()
 * @method $this withNetworkInterfaceId($value)
 */
class DetachNetworkInterface extends Rpc
{
}

/**
 * @method string getData()
 * @method $this withData($value)
 * @method string getDistStrategy()
 * @method $this withDistStrategy($value)
 * @method string getAppId()
 * @method $this withAppId($value)
 */
class DistApplicationData extends Rpc
{
}

/**
 * @method string getStartDate()
 * @method $this withStartDate($value)
 * @method string getEndDate()
 * @method $this withEndDate($value)
 */
class ExportBillDetailData extends Rpc
{
}

/**
 * @method string getImageId()
 * @method $this withImageId($value)
 * @method string getOSSRegionId()
 * @method $this withOSSRegionId($value)
 * @method string getOSSBucket()
 * @method $this withOSSBucket($value)
 * @method string getRoleName()
 * @method $this withRoleName($value)
 * @method string getOSSPrefix()
 * @method $this withOSSPrefix($value)
 */
class ExportImage extends Rpc
{
}

/**
 * @method string getStartDate()
 * @method $this withStartDate($value)
 * @method string getEndDate()
 * @method $this withEndDate($value)
 */
class ExportMeasurementData extends Rpc
{
}

/**
 * @method string getBucketName()
 * @method $this withBucketName($value)
 */
class GetBucketAcl extends Rpc
{

    /** @var string */
    public $scheme = 'https';
}

/**
 * @method string getBucketName()
 * @method $this withBucketName($value)
 */
class GetBucketInfo extends Rpc
{
}

/**
 * @method string getBucketName()
 * @method $this withBucketName($value)
 * @method string getRuleId()
 * @method $this withRuleId($value)
 */
class GetBucketLifecycle extends Rpc
{
}

/**
 * @method string getNatType()
 * @method $this withNatType($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getRuleId()
 * @method $this withRuleId($value)
 */
class GetDeviceInternetPort extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getBucketList()
 * @method $this withBucketList($value)
 */
class GetOssStorageAndAccByBuckets extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getPeriod()
 * @method $this withPeriod($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getBucket()
 * @method $this withBucket($value)
 */
class GetOssUsageData extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getKeyPairName()
 * @method $this withKeyPairName($value)
 * @method string getPublicKeyBody()
 * @method $this withPublicKeyBody($value)
 */
class ImportKeyPair extends Rpc
{
}

/**
 * @method string getEPNInstanceId()
 * @method $this withEPNInstanceId($value)
 * @method string getInstanceInfos()
 * @method $this withInstanceInfos($value)
 */
class JoinPublicIpsToEpnInstance extends Rpc
{
}

/**
 * @method string getSecurityGroupId()
 * @method $this withSecurityGroupId($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getNetworkInterfaceId()
 * @method $this withNetworkInterfaceId($value)
 */
class JoinSecurityGroup extends Rpc
{
}

/**
 * @method string getVSwitchesInfo()
 * @method $this withVSwitchesInfo($value)
 * @method string getEPNInstanceId()
 * @method $this withEPNInstanceId($value)
 */
class JoinVSwitchesToEpnInstance extends Rpc
{
}

/**
 * @method string getSecurityGroupId()
 * @method $this withSecurityGroupId($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getNetworkInterfaceId()
 * @method $this withNetworkInterfaceId($value)
 */
class LeaveSecurityGroup extends Rpc
{
}

/**
 * @method string getClusterNames()
 * @method $this withClusterNames($value)
 * @method string getLevel()
 * @method $this withLevel($value)
 * @method string getOutAppInfoParams()
 * @method $this withOutAppInfoParams($value)
 * @method string getMaxDate()
 * @method $this withMaxDate($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getAppVersions()
 * @method $this withAppVersions($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getMinDate()
 * @method $this withMinDate($value)
 */
class ListApplications extends Rpc
{
}

/**
 * @method string getPrefix()
 * @method $this withPrefix($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getKeyword()
 * @method $this withKeyword($value)
 * @method string getLogicalBucketType()
 * @method $this withLogicalBucketType($value)
 * @method string getMarker()
 * @method $this withMarker($value)
 * @method string getPageNumber()
 * @method $this withPageNumber($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class ListBuckets extends Rpc
{
}

/**
 * @method string getMaxKeys()
 * @method $this withMaxKeys($value)
 * @method string getContinuationToken()
 * @method $this withContinuationToken($value)
 * @method string getPrefix()
 * @method $this withPrefix($value)
 * @method string getDelimiter()
 * @method $this withDelimiter($value)
 * @method string getMarker()
 * @method $this withMarker($value)
 * @method string getBucketName()
 * @method $this withBucketName($value)
 * @method string getEncodingType()
 * @method $this withEncodingType($value)
 * @method string getStartAfter()
 * @method $this withStartAfter($value)
 */
class ListObjects extends Rpc
{
}

/**
 * @method string getNextToken()
 * @method $this withNextToken($value)
 * @method array getTag()
 * @method array getResourceId()
 * @method string getResourceType()
 * @method $this withResourceType($value)
 */
class ListTagResources extends Rpc
{

    /**
     * @param array $tag
     *
     * @return $this
     */
	public function withTag(array $tag)
	{
	    $this->data['Tag'] = $tag;
		foreach ($tag as $depth1 => $depth1Value) {
			if(isset($depth1Value['Value'])){
				$this->options['query']['Tag.' . ($depth1 + 1) . '.Value'] = $depth1Value['Value'];
			}
			if(isset($depth1Value['Key'])){
				$this->options['query']['Tag.' . ($depth1 + 1) . '.Key'] = $depth1Value['Key'];
			}
		}

		return $this;
    }

    /**
     * @param array $resourceId
     *
     * @return $this
     */
	public function withResourceId(array $resourceId)
	{
	    $this->data['ResourceId'] = $resourceId;
		foreach ($resourceId as $i => $iValue) {
			$this->options['query']['ResourceId.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getAllocationId()
 * @method $this withAllocationId($value)
 * @method string getBandwidth()
 * @method $this withBandwidth($value)
 * @method string getName()
 * @method $this withName($value)
 */
class ModifyEnsEipAddressAttribute extends Rpc
{
}

/**
 * @method string getNetworkingModel()
 * @method $this withNetworkingModel($value)
 * @method string getInternetMaxBandwidthOut()
 * @method $this withInternetMaxBandwidthOut($value)
 * @method string getEPNInstanceId()
 * @method $this withEPNInstanceId($value)
 * @method string getEPNInstanceName()
 * @method $this withEPNInstanceName($value)
 */
class ModifyEpnInstance extends Rpc
{
}

/**
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getFileSystemId()
 * @method $this withFileSystemId($value)
 */
class ModifyFileSystem extends Rpc
{
}

/**
 * @method string getForwardEntryId()
 * @method $this withForwardEntryId($value)
 * @method string getForwardEntryName()
 * @method $this withForwardEntryName($value)
 * @method string getHealthCheckPort()
 * @method $this withHealthCheckPort($value)
 */
class ModifyForwardEntry extends Rpc
{
}

/**
 * @method string getHaVipId()
 * @method $this withHaVipId($value)
 * @method string getName()
 * @method $this withName($value)
 */
class ModifyHaVipAttribute extends Rpc
{
}

/**
 * @method string getImageId()
 * @method $this withImageId($value)
 * @method string getImageName()
 * @method $this withImageName($value)
 */
class ModifyImageAttribute extends Rpc
{
}

/**
 * @method string getImageId()
 * @method $this withImageId($value)
 * @method string getRemoveAccounts()
 * @method $this withRemoveAccounts($value)
 * @method string getAddAccounts()
 * @method $this withAddAccounts($value)
 */
class ModifyImageSharePermission extends Rpc
{
}

/**
 * @method string getUserData()
 * @method $this withUserData($value)
 * @method string getPassword()
 * @method $this withPassword($value)
 * @method string getHostName()
 * @method $this withHostName($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getInstanceName()
 * @method $this withInstanceName($value)
 */
class ModifyInstanceAttribute extends Rpc
{
}

/**
 * @method string getDuration()
 * @method $this withDuration($value)
 * @method string getRenewalStatus()
 * @method $this withRenewalStatus($value)
 * @method string getOwnerId()
 * @method $this withOwnerId($value)
 * @method string getAutoRenew()
 * @method $this withAutoRenew($value)
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 */
class ModifyInstanceAutoRenewAttribute extends Rpc
{
}

/**
 * @method string getDiskSet()
 * @method $this withDiskSet($value)
 * @method string getBootType()
 * @method $this withBootType($value)
 * @method string getBootSet()
 * @method $this withBootSet($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class ModifyInstanceBootConfiguration extends Rpc
{

    /** @var string */
    public $scheme = 'https';

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getPeriod()
 * @method $this withPeriod($value)
 * @method string getIncludeDataDisks()
 * @method $this withIncludeDataDisks($value)
 * @method string getPeriodUnit()
 * @method $this withPeriodUnit($value)
 * @method string getAutoRenew()
 * @method $this withAutoRenew($value)
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 * @method string getInstanceChargeType()
 * @method $this withInstanceChargeType($value)
 * @method string getAutoPay()
 * @method $this withAutoPay($value)
 */
class ModifyInstanceChargeType extends Rpc
{
}

/**
 * @method string getLoadBalancerName()
 * @method $this withLoadBalancerName($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 */
class ModifyLoadBalancerAttribute extends Rpc
{
}

/**
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getNetworkName()
 * @method $this withNetworkName($value)
 * @method string getNetworkId()
 * @method $this withNetworkId($value)
 */
class ModifyNetworkAttribute extends Rpc
{
}

/**
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getNetworkInterfaceName()
 * @method $this withNetworkInterfaceName($value)
 * @method string getNetworkInterfaceId()
 * @method $this withNetworkInterfaceId($value)
 */
class ModifyNetworkInterfaceAttribute extends Rpc
{
}

/**
 * @method string getInstanceType()
 * @method $this withInstanceType($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class ModifyPrepayInstanceSpec extends Rpc
{
}

/**
 * @method string getSecurityGroupId()
 * @method $this withSecurityGroupId($value)
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getSecurityGroupName()
 * @method $this withSecurityGroupName($value)
 */
class ModifySecurityGroupAttribute extends Rpc
{
}

/**
 * @method string getSnapshotId()
 * @method $this withSnapshotId($value)
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getSnapshotName()
 * @method $this withSnapshotName($value)
 */
class ModifySnapshotAttribute extends Rpc
{
}

/**
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getVSwitchId()
 * @method $this withVSwitchId($value)
 * @method string getVSwitchName()
 * @method $this withVSwitchName($value)
 */
class ModifyVSwitchAttribute extends Rpc
{
}

/**
 * @method string getDestinationRegionIds()
 * @method $this withDestinationRegionIds($value)
 * @method string getSDGId()
 * @method $this withSDGId($value)
 * @method string getRedundantNum()
 * @method $this withRedundantNum($value)
 * @method string getNamespaces()
 * @method $this withNamespaces($value)
 */
class PreloadRegionSDG extends Rpc
{

    /** @var string */
    public $scheme = 'https';
}

/**
 * @method string getClientIp()
 * @method $this withClientIp($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method string getAdditionType()
 * @method $this withAdditionType($value)
 * @method string getBucketName()
 * @method $this withBucketName($value)
 * @method string getStation()
 * @method $this withStation($value)
 * @method string getObjectKey()
 * @method $this withObjectKey($value)
 * @method string getStorageCost()
 * @method $this withStorageCost($value)
 */
class PrepareUpload extends Rpc
{
}

/**
 * @method string getData()
 * @method $this withData($value)
 * @method string getTimeout()
 * @method $this withTimeout($value)
 * @method string getPushStrategy()
 * @method $this withPushStrategy($value)
 * @method string getAppId()
 * @method $this withAppId($value)
 */
class PushApplicationData extends Rpc
{
}

/**
 * @method string getEnsRegionId()
 * @method string getLogicalBucketType()
 * @method string getCity()
 * @method string getDataRedundancyType()
 * @method string getEndpoint()
 * @method string getBucketName()
 * @method string getStorageDomainId()
 * @method string getEngineId()
 * @method string getBucketAcl()
 * @method string getDispatcherType()
 * @method string getResourceType()
 * @method string getStorageClass()
 * @method string getDispatchScope()
 * @method string getComment()
 */
class PutBucket extends Rpc
{

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withEnsRegionId($value)
    {
        $this->data['EnsRegionId'] = $value;
        $this->options['form_params']['EnsRegionId'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withLogicalBucketType($value)
    {
        $this->data['LogicalBucketType'] = $value;
        $this->options['form_params']['LogicalBucketType'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withCity($value)
    {
        $this->data['City'] = $value;
        $this->options['form_params']['City'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withDataRedundancyType($value)
    {
        $this->data['DataRedundancyType'] = $value;
        $this->options['form_params']['DataRedundancyType'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withEndpoint($value)
    {
        $this->data['Endpoint'] = $value;
        $this->options['form_params']['Endpoint'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withBucketName($value)
    {
        $this->data['BucketName'] = $value;
        $this->options['form_params']['BucketName'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withStorageDomainId($value)
    {
        $this->data['StorageDomainId'] = $value;
        $this->options['form_params']['StorageDomainId'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withEngineId($value)
    {
        $this->data['EngineId'] = $value;
        $this->options['form_params']['EngineId'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withBucketAcl($value)
    {
        $this->data['BucketAcl'] = $value;
        $this->options['form_params']['BucketAcl'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withDispatcherType($value)
    {
        $this->data['DispatcherType'] = $value;
        $this->options['form_params']['DispatcherType'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withResourceType($value)
    {
        $this->data['ResourceType'] = $value;
        $this->options['form_params']['ResourceType'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withStorageClass($value)
    {
        $this->data['StorageClass'] = $value;
        $this->options['form_params']['StorageClass'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withDispatchScope($value)
    {
        $this->data['DispatchScope'] = $value;
        $this->options['form_params']['DispatchScope'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withComment($value)
    {
        $this->data['Comment'] = $value;
        $this->options['form_params']['Comment'] = $value;

        return $this;
    }
}

/**
 * @method string getBucketName()
 * @method $this withBucketName($value)
 * @method string getBucketAcl()
 * @method $this withBucketAcl($value)
 */
class PutBucketAcl extends Rpc
{
}

/**
 * @method string getPrefix()
 * @method $this withPrefix($value)
 * @method string getAllowSameActionOverlap()
 * @method $this withAllowSameActionOverlap($value)
 * @method string getExpirationDays()
 * @method $this withExpirationDays($value)
 * @method string getRuleId()
 * @method $this withRuleId($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 * @method string getBucketName()
 * @method $this withBucketName($value)
 * @method string getCreatedBeforeDate()
 * @method $this withCreatedBeforeDate($value)
 */
class PutBucketLifecycle extends Rpc
{
}

/**
 * @method string getServerId()
 * @method $this withServerId($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 */
class RebootAICInstance extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getServerId()
 * @method $this withServerId($value)
 */
class RebootARMServerInstance extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getForceStop()
 * @method $this withForceStop($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class RebootInstance extends Rpc
{
}

/**
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 */
class RebootInstances extends Rpc
{
}

/**
 * @method string getServerId()
 * @method $this withServerId($value)
 */
class RecoverAICInstance extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getImageId()
 * @method $this withImageId($value)
 * @method string getDiskId()
 * @method $this withDiskId($value)
 */
class ReInitDisk extends Rpc
{
}

/**
 * @method string getImageId()
 * @method string getPassword()
 * @method string getInstanceId()
 */
class ReinitInstance extends Rpc
{

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withImageId($value)
    {
        $this->data['ImageId'] = $value;
        $this->options['form_params']['ImageId'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withPassword($value)
    {
        $this->data['Password'] = $value;
        $this->options['form_params']['Password'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withInstanceId($value)
    {
        $this->data['InstanceId'] = $value;
        $this->options['form_params']['InstanceId'] = $value;

        return $this;
    }
}

/**
 * @method string getImageId()
 * @method $this withImageId($value)
 * @method string getPassword()
 * @method $this withPassword($value)
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 */
class ReinitInstances extends Rpc
{
}

/**
 * @method string getServerId()
 * @method $this withServerId($value)
 */
class ReleaseAICInstance extends Rpc
{
}

/**
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class ReleaseARMServerInstance extends Rpc
{
}

/**
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class ReleaseInstance extends Rpc
{
}

/**
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class ReleasePostPaidInstance extends Rpc
{
}

/**
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class ReleasePrePaidInstance extends Rpc
{
}

/**
 * @method string getBackendServers()
 * @method $this withBackendServers($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 */
class RemoveBackendServers extends Rpc
{
}

/**
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 */
class RemoveInstanceSDG extends Rpc
{
}

/**
 * @method string getEPNInstanceId()
 * @method $this withEPNInstanceId($value)
 * @method string getInstanceInfos()
 * @method $this withInstanceInfos($value)
 */
class RemovePublicIpsFromEpnInstance extends Rpc
{
}

/**
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 */
class RemoveSDG extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getVSwitchesInfo()
 * @method $this withVSwitchesInfo($value)
 * @method string getEPNInstanceId()
 * @method $this withEPNInstanceId($value)
 */
class RemoveVSwitchesFromEpnInstance extends Rpc
{
}

/**
 * @method string getPeriod()
 * @method $this withPeriod($value)
 * @method string getPeriodUnit()
 * @method $this withPeriodUnit($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getAutoRenew()
 * @method $this withAutoRenew($value)
 */
class RenewARMServerInstance extends Rpc
{
}

/**
 * @method string getPeriod()
 * @method $this withPeriod($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class RenewInstance extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getRescaleType()
 * @method $this withRescaleType($value)
 * @method string getResourceSelector()
 * @method $this withResourceSelector($value)
 * @method string getTimeout()
 * @method $this withTimeout($value)
 * @method string getRescaleLevel()
 * @method $this withRescaleLevel($value)
 * @method string getAppId()
 * @method $this withAppId($value)
 * @method string getToAppVersion()
 * @method $this withToAppVersion($value)
 */
class RescaleApplication extends Rpc
{
}

/**
 * @method string getResourceSelector()
 * @method string getResourceInfo()
 * @method string getRescaleType()
 * @method $this withRescaleType($value)
 * @method string getImageId()
 * @method $this withImageId($value)
 * @method string getTimeout()
 * @method $this withTimeout($value)
 * @method string getRescaleLevel()
 * @method $this withRescaleLevel($value)
 * @method string getResourceSpec()
 * @method $this withResourceSpec($value)
 * @method string getIpType()
 * @method $this withIpType($value)
 * @method string getAppId()
 * @method $this withAppId($value)
 * @method string getServiceId()
 * @method $this withServiceId($value)
 */
class RescaleDeviceService extends Rpc
{

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withResourceSelector($value)
    {
        $this->data['ResourceSelector'] = $value;
        $this->options['form_params']['ResourceSelector'] = $value;

        return $this;
    }

    /**
     * @param string $value
     *
     * @return $this
     */
    public function withResourceInfo($value)
    {
        $this->data['ResourceInfo'] = $value;
        $this->options['form_params']['ResourceInfo'] = $value;

        return $this;
    }
}

/**
 * @method string getServerId()
 * @method $this withServerId($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class ResetAICInstance extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getImageId()
 * @method $this withImageId($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getAppId()
 * @method $this withAppId($value)
 */
class ResetDeviceInstance extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getSnapshotId()
 * @method $this withSnapshotId($value)
 * @method string getDiskId()
 * @method $this withDiskId($value)
 */
class ResetDisk extends Rpc
{
}

/**
 * @method string getDiskId()
 * @method $this withDiskId($value)
 * @method string getNewSize()
 * @method $this withNewSize($value)
 */
class ResizeDisk extends Rpc
{
}

/**
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getAppId()
 * @method $this withAppId($value)
 */
class RestartDeviceInstance extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getSourcePortRange()
 * @method $this withSourcePortRange($value)
 * @method string getPortRange()
 * @method $this withPortRange($value)
 * @method string getIpProtocol()
 * @method $this withIpProtocol($value)
 * @method string getSourceCidrIp()
 * @method $this withSourceCidrIp($value)
 * @method string getPriority()
 * @method $this withPriority($value)
 * @method string getSecurityGroupId()
 * @method $this withSecurityGroupId($value)
 * @method string getPolicy()
 * @method $this withPolicy($value)
 */
class RevokeSecurityGroup extends Rpc
{
}

/**
 * @method string getSourcePortRange()
 * @method $this withSourcePortRange($value)
 * @method string getPortRange()
 * @method $this withPortRange($value)
 * @method string getIpProtocol()
 * @method $this withIpProtocol($value)
 * @method string getPriority()
 * @method $this withPriority($value)
 * @method string getDestCidrIp()
 * @method $this withDestCidrIp($value)
 * @method string getSecurityGroupId()
 * @method $this withSecurityGroupId($value)
 * @method string getPolicy()
 * @method $this withPolicy($value)
 */
class RevokeSecurityGroupEgress extends Rpc
{
}

/**
 * @method string getTimeout()
 * @method $this withTimeout($value)
 * @method string getFromAppVersion()
 * @method $this withFromAppVersion($value)
 * @method string getAppId()
 * @method $this withAppId($value)
 * @method string getToAppVersion()
 * @method $this withToAppVersion($value)
 */
class RollbackApplication extends Rpc
{
}

/**
 * @method string getScheduleAreaLevel()
 * @method $this withScheduleAreaLevel($value)
 * @method string getUniqueSuffix()
 * @method $this withUniqueSuffix($value)
 * @method string getInstanceChargeStrategy()
 * @method $this withInstanceChargeStrategy($value)
 * @method string getSecurityId()
 * @method $this withSecurityId($value)
 * @method string getKeyPairName()
 * @method $this withKeyPairName($value)
 * @method string getPassword()
 * @method $this withPassword($value)
 * @method string getHostName()
 * @method $this withHostName($value)
 * @method string getSystemDisk()
 * @method $this withSystemDisk($value)
 * @method string getNetDistrictCode()
 * @method $this withNetDistrictCode($value)
 * @method string getEnsRegionId()
 * @method $this withEnsRegionId($value)
 * @method array getTag()
 * @method string getPeriod()
 * @method $this withPeriod($value)
 * @method string getPublicIpIdentification()
 * @method $this withPublicIpIdentification($value)
 * @method string getBillingCycle()
 * @method $this withBillingCycle($value)
 * @method string getVSwitchId()
 * @method $this withVSwitchId($value)
 * @method string getPrivateIpAddress()
 * @method $this withPrivateIpAddress($value)
 * @method string getSpotStrategy()
 * @method $this withSpotStrategy($value)
 * @method string getPeriodUnit()
 * @method $this withPeriodUnit($value)
 * @method string getInstanceName()
 * @method $this withInstanceName($value)
 * @method string getAutoRenew()
 * @method $this withAutoRenew($value)
 * @method string getInternetChargeType()
 * @method $this withInternetChargeType($value)
 * @method string getNetWorkId()
 * @method $this withNetWorkId($value)
 * @method string getSchedulingPriceStrategy()
 * @method $this withSchedulingPriceStrategy($value)
 * @method string getImageId()
 * @method $this withImageId($value)
 * @method string getInternetMaxBandwidthOut()
 * @method $this withInternetMaxBandwidthOut($value)
 * @method string getAutoUseCoupon()
 * @method $this withAutoUseCoupon($value)
 * @method string getUserData()
 * @method $this withUserData($value)
 * @method string getPasswordInherit()
 * @method $this withPasswordInherit($value)
 * @method string getInstanceType()
 * @method $this withInstanceType($value)
 * @method string getInstanceChargeType()
 * @method $this withInstanceChargeType($value)
 * @method string getAmount()
 * @method $this withAmount($value)
 * @method string getAutoReleaseTime()
 * @method $this withAutoReleaseTime($value)
 * @method string getIpType()
 * @method $this withIpType($value)
 * @method string getSpotDuration()
 * @method $this withSpotDuration($value)
 * @method string getDataDisk()
 * @method $this withDataDisk($value)
 * @method string getSchedulingStrategy()
 * @method $this withSchedulingStrategy($value)
 * @method string getCarrier()
 * @method $this withCarrier($value)
 */
class RunInstances extends Rpc
{

    /**
     * @param array $tag
     *
     * @return $this
     */
	public function withTag(array $tag)
	{
	    $this->data['Tag'] = $tag;
		foreach ($tag as $depth1 => $depth1Value) {
			if(isset($depth1Value['Value'])){
				$this->options['query']['Tag.' . ($depth1 + 1) . '.Value'] = $depth1Value['Value'];
			}
			if(isset($depth1Value['Key'])){
				$this->options['query']['Tag.' . ($depth1 + 1) . '.Key'] = $depth1Value['Key'];
			}
		}

		return $this;
    }
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getClientIp()
 * @method $this withClientIp($value)
 * @method string getPodConfigName()
 * @method $this withPodConfigName($value)
 * @method string getServiceCommands()
 * @method $this withServiceCommands($value)
 * @method string getScheduleStrategy()
 * @method $this withScheduleStrategy($value)
 * @method string getDirectorys()
 * @method $this withDirectorys($value)
 * @method string getPreLockedTimeout()
 * @method $this withPreLockedTimeout($value)
 * @method string getServiceAction()
 * @method $this withServiceAction($value)
 * @method string getAppId()
 * @method $this withAppId($value)
 */
class RunServiceSchedule extends Rpc
{
}

/**
 * @method string getSDGId()
 * @method $this withSDGId($value)
 */
class SaveSDG extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getBackendServers()
 * @method $this withBackendServers($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 */
class SetBackendServers extends Rpc
{
}

/**
 * @method string getHealthCheckTimeout()
 * @method $this withHealthCheckTimeout($value)
 * @method string getHealthCheckURI()
 * @method $this withHealthCheckURI($value)
 * @method string getXForwardedFor()
 * @method $this withXForwardedFor($value)
 * @method string getHealthCheck()
 * @method $this withHealthCheck($value)
 * @method string getProtocol()
 * @method $this withProtocol($value)
 * @method string getCookie()
 * @method $this withCookie($value)
 * @method string getHealthCheckMethod()
 * @method $this withHealthCheckMethod($value)
 * @method string getHealthCheckDomain()
 * @method $this withHealthCheckDomain($value)
 * @method string getRequestTimeout()
 * @method $this withRequestTimeout($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 * @method string getHealthCheckInterval()
 * @method $this withHealthCheckInterval($value)
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getUnhealthyThreshold()
 * @method $this withUnhealthyThreshold($value)
 * @method string getHealthyThreshold()
 * @method $this withHealthyThreshold($value)
 * @method string getScheduler()
 * @method $this withScheduler($value)
 * @method string getCookieTimeout()
 * @method $this withCookieTimeout($value)
 * @method string getStickySessionType()
 * @method $this withStickySessionType($value)
 * @method string getListenerPort()
 * @method $this withListenerPort($value)
 * @method string getStickySession()
 * @method $this withStickySession($value)
 * @method string getIdleTimeout()
 * @method $this withIdleTimeout($value)
 * @method string getHealthCheckConnectPort()
 * @method $this withHealthCheckConnectPort($value)
 * @method string getHealthCheckHttpCode()
 * @method $this withHealthCheckHttpCode($value)
 */
class SetLoadBalancerHTTPListenerAttribute extends Rpc
{
}

/**
 * @method string getHealthCheckTimeout()
 * @method $this withHealthCheckTimeout($value)
 * @method string getHealthCheckURI()
 * @method $this withHealthCheckURI($value)
 * @method string getHealthCheck()
 * @method $this withHealthCheck($value)
 * @method string getProtocol()
 * @method $this withProtocol($value)
 * @method string getCookie()
 * @method $this withCookie($value)
 * @method string getHealthCheckMethod()
 * @method $this withHealthCheckMethod($value)
 * @method string getHealthCheckDomain()
 * @method $this withHealthCheckDomain($value)
 * @method string getRequestTimeout()
 * @method $this withRequestTimeout($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 * @method string getHealthCheckInterval()
 * @method $this withHealthCheckInterval($value)
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getUnhealthyThreshold()
 * @method $this withUnhealthyThreshold($value)
 * @method string getHealthyThreshold()
 * @method $this withHealthyThreshold($value)
 * @method string getScheduler()
 * @method $this withScheduler($value)
 * @method string getCookieTimeout()
 * @method $this withCookieTimeout($value)
 * @method string getStickySessionType()
 * @method $this withStickySessionType($value)
 * @method string getListenerPort()
 * @method $this withListenerPort($value)
 * @method string getStickySession()
 * @method $this withStickySession($value)
 * @method string getServerCertificateId()
 * @method $this withServerCertificateId($value)
 * @method string getIdleTimeout()
 * @method $this withIdleTimeout($value)
 * @method string getHealthCheckConnectPort()
 * @method $this withHealthCheckConnectPort($value)
 * @method string getHealthCheckHttpCode()
 * @method $this withHealthCheckHttpCode($value)
 */
class SetLoadBalancerHTTPSListenerAttribute extends Rpc
{
}

/**
 * @method string getLoadBalancerStatus()
 * @method $this withLoadBalancerStatus($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 */
class SetLoadBalancerStatus extends Rpc
{
}

/**
 * @method string getHealthCheckURI()
 * @method $this withHealthCheckURI($value)
 * @method string getProtocol()
 * @method $this withProtocol($value)
 * @method string getEstablishedTimeout()
 * @method $this withEstablishedTimeout($value)
 * @method string getPersistenceTimeout()
 * @method $this withPersistenceTimeout($value)
 * @method string getHealthCheckDomain()
 * @method $this withHealthCheckDomain($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 * @method string getHealthCheckInterval()
 * @method $this withHealthCheckInterval($value)
 * @method string getHealthCheckConnectTimeout()
 * @method $this withHealthCheckConnectTimeout($value)
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getUnhealthyThreshold()
 * @method $this withUnhealthyThreshold($value)
 * @method string getHealthyThreshold()
 * @method $this withHealthyThreshold($value)
 * @method string getScheduler()
 * @method $this withScheduler($value)
 * @method string getEipTransmit()
 * @method $this withEipTransmit($value)
 * @method string getListenerPort()
 * @method $this withListenerPort($value)
 * @method string getHealthCheckType()
 * @method $this withHealthCheckType($value)
 * @method string getHealthCheckConnectPort()
 * @method $this withHealthCheckConnectPort($value)
 * @method string getHealthCheckHttpCode()
 * @method $this withHealthCheckHttpCode($value)
 */
class SetLoadBalancerTCPListenerAttribute extends Rpc
{
}

/**
 * @method string getProtocol()
 * @method $this withProtocol($value)
 * @method string getEstablishedTimeout()
 * @method $this withEstablishedTimeout($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 * @method string getHealthCheckReq()
 * @method $this withHealthCheckReq($value)
 * @method string getHealthCheckInterval()
 * @method $this withHealthCheckInterval($value)
 * @method string getHealthCheckExp()
 * @method $this withHealthCheckExp($value)
 * @method string getHealthCheckConnectTimeout()
 * @method $this withHealthCheckConnectTimeout($value)
 * @method string getDescription()
 * @method $this withDescription($value)
 * @method string getUnhealthyThreshold()
 * @method $this withUnhealthyThreshold($value)
 * @method string getHealthyThreshold()
 * @method $this withHealthyThreshold($value)
 * @method string getScheduler()
 * @method $this withScheduler($value)
 * @method string getEipTransmit()
 * @method $this withEipTransmit($value)
 * @method string getListenerPort()
 * @method $this withListenerPort($value)
 * @method string getHealthCheckConnectPort()
 * @method $this withHealthCheckConnectPort($value)
 */
class SetLoadBalancerUDPListenerAttribute extends Rpc
{
}

/**
 * @method string getEPNInstanceId()
 * @method $this withEPNInstanceId($value)
 */
class StartEpnInstance extends Rpc
{
}

/**
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class StartInstance extends Rpc
{
}

/**
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 */
class StartInstances extends Rpc
{
}

/**
 * @method string getListenerPort()
 * @method $this withListenerPort($value)
 * @method string getListenerProtocol()
 * @method $this withListenerProtocol($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 */
class StartLoadBalancerListener extends Rpc
{
}

/**
 * @method string getSnatIp()
 * @method $this withSnatIp($value)
 * @method string getSnatEntryId()
 * @method $this withSnatEntryId($value)
 */
class StartSnatIpForSnatEntry extends Rpc
{
}

/**
 * @method string getEPNInstanceId()
 * @method $this withEPNInstanceId($value)
 */
class StopEpnInstance extends Rpc
{
}

/**
 * @method string getForceStop()
 * @method $this withForceStop($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class StopInstance extends Rpc
{
}

/**
 * @method string getInstanceIds()
 * @method $this withInstanceIds($value)
 */
class StopInstances extends Rpc
{
}

/**
 * @method string getListenerPort()
 * @method $this withListenerPort($value)
 * @method string getListenerProtocol()
 * @method $this withListenerProtocol($value)
 * @method string getLoadBalancerId()
 * @method $this withLoadBalancerId($value)
 */
class StopLoadBalancerListener extends Rpc
{
}

/**
 * @method string getSnatIp()
 * @method $this withSnatIp($value)
 * @method string getSnatEntryId()
 * @method $this withSnatEntryId($value)
 */
class StopSnatIpForSnatEntry extends Rpc
{
}

/**
 * @method array getTag()
 * @method array getResourceId()
 * @method string getResourceType()
 * @method $this withResourceType($value)
 */
class TagResources extends Rpc
{

    /**
     * @param array $tag
     *
     * @return $this
     */
	public function withTag(array $tag)
	{
	    $this->data['Tag'] = $tag;
		foreach ($tag as $depth1 => $depth1Value) {
			if(isset($depth1Value['Value'])){
				$this->options['query']['Tag.' . ($depth1 + 1) . '.Value'] = $depth1Value['Value'];
			}
			if(isset($depth1Value['Key'])){
				$this->options['query']['Tag.' . ($depth1 + 1) . '.Key'] = $depth1Value['Key'];
			}
		}

		return $this;
    }

    /**
     * @param array $resourceId
     *
     * @return $this
     */
	public function withResourceId(array $resourceId)
	{
	    $this->data['ResourceId'] = $resourceId;
		foreach ($resourceId as $i => $iValue) {
			$this->options['query']['ResourceId.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getPrivateIpAddress()
 * @method $this withPrivateIpAddress($value)
 * @method string getNetworkInterfaceId()
 * @method $this withNetworkInterfaceId($value)
 */
class UnassignPrivateIpAddresses extends Rpc
{
}

/**
 * @method string getAllocationId()
 * @method $this withAllocationId($value)
 */
class UnAssociateEnsEipAddress extends Rpc
{
}

/**
 * @method string getHaVipId()
 * @method $this withHaVipId($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class UnassociateHaVip extends Rpc
{
}

/**
 * @method string getNetworkAclId()
 * @method $this withNetworkAclId($value)
 * @method string getResource()
 * @method $this withResource($value)
 */
class UnassociateNetworkAcl extends Rpc
{
}

/**
 * @method string getDestinationRegionIds()
 * @method $this withDestinationRegionIds($value)
 * @method string getSDGId()
 * @method $this withSDGId($value)
 * @method string getNamespaces()
 * @method $this withNamespaces($value)
 */
class UnloadRegionSDG extends Rpc
{

    /** @var string */
    public $scheme = 'https';
}

/**
 * @method string getAll()
 * @method $this withAll($value)
 * @method array getResourceId()
 * @method string getResourceType()
 * @method $this withResourceType($value)
 * @method array getTagKey()
 */
class UntagResources extends Rpc
{

    /**
     * @param array $resourceId
     *
     * @return $this
     */
	public function withResourceId(array $resourceId)
	{
	    $this->data['ResourceId'] = $resourceId;
		foreach ($resourceId as $i => $iValue) {
			$this->options['query']['ResourceId.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $tagKey
     *
     * @return $this
     */
	public function withTagKey(array $tagKey)
	{
	    $this->data['TagKey'] = $tagKey;
		foreach ($tagKey as $i => $iValue) {
			$this->options['query']['TagKey.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSaleControls()
 * @method $this withSaleControls($value)
 * @method string getCustomAccount()
 * @method $this withCustomAccount($value)
 * @method string getCommodityCode()
 * @method $this withCommodityCode($value)
 * @method string getAliUidAccount()
 * @method $this withAliUidAccount($value)
 */
class UpdateEnsSaleControl extends Rpc
{
}

/**
 * @method string getImageId()
 * @method $this withImageId($value)
 * @method string getTimeout()
 * @method $this withTimeout($value)
 * @method string getServerIds()
 * @method $this withServerIds($value)
 */
class UpgradeAICInstanceImage extends Rpc
{

    /** @var string */
    public $method = 'GET';
}

/**
 * @method string getTemplate()
 * @method $this withTemplate($value)
 * @method string getTimeout()
 * @method $this withTimeout($value)
 * @method string getAppId()
 * @method $this withAppId($value)
 */
class UpgradeApplication extends Rpc
{
}
